#include "mbed.h"

//updated for 2019

//Function declarations
void Function1();
void Function2();

//I/O
DigitalOut onBoardLED(LED1);
DigitalOut redLED(PE_15);
DigitalOut yellowLED(PB_10);
DigitalOut greenLED(PB_11);

DigitalIn  onBoardSwitch(USER_BUTTON);
DigitalIn  SW1(PE_12);
DigitalIn  SW2(PE_14);

//Create thread objects
Thread t1, t2, t3;

//Thread
void Function1()
{
    while (true) {
        redLED = !redLED;
        ThisThread::sleep_for(2000);
    }
}

//Thread
void Function2()
{
    while (true) {
        yellowLED = !yellowLED;
        ThisThread::sleep_for(1000);
    }
}

//Green Flashing
void Function3()
{
    while (true) {
        greenLED = !greenLED;
        ThisThread::sleep_for(500);
    }
}

//Main thread
int main() {
    //Initial state
    redLED    = 0;
    yellowLED = 0;
    greenLED  = 0;
    
    //Create and run threads (C function pointers)
    t1.start(Function1);           
    t2.start(Function2);    
    t3.start(Function3);
        
    //Main thread loop
    while(1) {
        //ThisThread::sleep_for(osWaitForever);
        ThisThread::sleep_for(5000);
        printf("Main is Awake\n");  //Should not happen when osWaitForever is used
    }
}
