#include "mbed.h"

DigitalOut OnBoardLed(LED1);

#ifdef TARGET_NUCLEO_F429ZI
PwmOut pwmRed(D6);  //D7 is not a PWM output on the F429, so use D6 instead
#else
PwmOut pwmRed(D7);
#endif

int T = 10;
int Tmark = 5;

int main() {
    
    pwmRed.period_us(T);
    pwmRed.pulsewidth_us(Tmark);
    
    while(1) {
        //Heartbeat
        wait(1);
        OnBoardLed = !OnBoardLed;
    }
}
