#include "mbed.h"

//Function prototype
void doSample1Hz();

//Global objects
Serial pc(USBTX, USBRX);
AnalogIn POT_ADC_In(A0);
DigitalOut led(LED1);

#define N 16 

//Shared variables
volatile static uint16_t sample16 = 0;

uint32_t sum = 0;
uint32_t counter = 0;

//The ticker, used to sample data at a fixed rate
Ticker t;

//Main function
int main()
{
    //Set baud rate to 115200
    pc.baud(115200);

    //Set up the ticker - 100Hz
    t.attach(doSample1Hz, 0.01);

    while(1) {

        //Sleep
        sleep();
        
        //Add new sample to the sum
        sum += sample16;
        
        //Increment the count
        counter = counter + 1;
        
        //Enough to calculate the average?
        if (counter == N) {
            //Divide sum by 16
            unsigned short mean = (sum >> 4);   
            
            //Display
            pc.printf("Mean = %hu\n", mean);
            wait(0.0014);   //Wait for buffer to clear
            
            //Reset sum and count
            counter = 0;
            sum = 0;
        }
 
    } //end while(1)
} //end main

//ISR for the ticker - simply there to perform sampling
void doSample1Hz()
{
    //Toggle on board led
    led = !led;

    //READ ADC as an unsigned integer.
    //Shift right 4 bits (this is a 12bit ADC) & store in static global variable
    sample16 = POT_ADC_In.read_u16() >> 4;
}


