#include "mbed.h"

#define N 1000000
#define RELEASED 0
#define PRESSED  1

//Function prototypes
void task1();
void task2();

//Hardware objects
DigitalOut red_led(PE_15);     //CountUp is in its critical section
DigitalOut yellow_led(PB_10);  //CountDown is in its critical section
DigitalOut green_led(PB_11);   //counter != 0
DigitalOut onboardLED(LED1);

DigitalIn button(USER_BUTTON);
DigitalIn sw1(PE_12);
DigitalIn sw2(PE_14);

//Two additional threads
Thread t1;
Thread t2;

int main() {
    
    //Light up
    red_led    = 1;
    yellow_led = 1;
    green_led  = 1;
    onboardLED = 1;
    
    //Start the two additional threads
    t1.start(task1);
    t2.start(task2);
    
    //Now loop forever
    while(1) { 
        //Flash the yellow on the "main thread"
        yellow_led = !yellow_led;
        Thread::wait(500);
    };
}


//Thread 1  - polling sw1 and controlling the red LED
void task1()
{
    //Loop forever
    while(1) {
        //Spin on sw1
        while (sw1 == RELEASED) {};
        //Allow short delay for switch bounce
        Thread::wait(200);
        //Spin again on sw1
        while (sw1 == PRESSED) {};    
        //Toggle LED
        red_led = !red_led;
        //Again, wait for switch bounce
        Thread::wait(200);
    }    
}

//Thread 2  - polling sw2 and controlling the green LED
void task2()
{
    //Loop forever
    while(1) {
        //Spin on sw2
        while (sw2 == RELEASED) {};
        //Allow short delay for switch bounce
        Thread::wait(200);
        //Spin again on sw2
        while (sw2 == PRESSED) {};    
        //Toggle LED
        green_led = !green_led;
        //Again, wait for switch bounce
        Thread::wait(200);
    }    
}
