#include "mbed.h"

#define N 1000000
#define RELEASED 0
#define PRESSED  1

//Hardware objects
DigitalOut red_led(PE_15);     //CountUp is in its critical section
DigitalOut yellow_led(PB_10);  //CountDown is in its critical section
DigitalOut green_led(PB_11);   //counter != 0
DigitalOut onboardLED(LED1);

DigitalIn button(USER_BUTTON);
DigitalIn sw1(PE_12);
DigitalIn sw2(PE_14);

//The code below is hugely flawed and is only to
//illustrate the problem of blocking hardware

// TASK - add some code to address the problem of switch bounce

int main() {
    
    //Light up
    red_led    = 1;
    yellow_led = 1;
    green_led  = 1;
    onboardLED = 1;
    
    //Now loop forever
    while(1) { 
    
        while (sw1 == RELEASED) {};
        while (sw1 == PRESSED) {};    
        red_led = !red_led;

        while (sw2 == RELEASED) {};
        while (sw2 == PRESSED) {};    
        green_led = !green_led;

        //Flash the yellow
        yellow_led = !yellow_led;
        wait(0.5);
    };
}

