#include "mbed.h"

void updateState();
void sw1RisingEdge();
void sw1FallingEdge();

#define EDGE_RISEN 1
#define EDGE_FALLEN 0

//Global Objects
DigitalOut    led(LED1);
InterruptIn   sw1(USER_BUTTON);

//State
static int sw1State = EDGE_FALLEN;     //Initial state for switch 1

//Interrupt service routine for handling the timeout
void updateState() {
    
    //Allow for switch bounce
    wait(0.1); 
    
    //Which event does this follow?
    switch (sw1State) {
    case EDGE_RISEN:    
        sw1.fall(callback(&sw1FallingEdge));  //Now wait for a falling edge
        break;
    case EDGE_FALLEN:
        sw1.rise(callback(&sw1RisingEdge));   //Now wait for a rising edge
        break;
    } //end switch 
}

//Interrupt service routine for a rising edge (press)
void sw1RisingEdge() {
    sw1.rise(NULL);             //Disable detecting more rising edges
    sw1State = EDGE_RISEN;      //Flag state
}

//Interrupt service routive for SW1 falling edge (release)
void sw1FallingEdge() {
    sw1.fall(NULL);                         //Disable this interrupt   
    sw1State = EDGE_FALLEN;                 //Flag state
}

//Main - only has to initialise and sleep
int main() {
    
    //Configure interrupts, wait for first rising edge
    sw1.rise(callback(&sw1RisingEdge));
    
    //Set LED to ON
    led    = 1;
     
    //Main Polling Loop
    while (true) {
  
        //Put CPU back to sleep
        sleep();                //woken by rising edge               
        updateState();
        
        sleep(); //Falling edge
        updateState();
        
        //You can ONLY reach this point if an ISR wakes the CPU twice
        led = !led;
        
    } //end while

}
