#include "mbed.h"

// This uses INTERRUPTS to detect a falling edge of the switch input
// However, pressing and releasing the switch can result in spurious falling edges
// which trigger the routine 

//Uncomment this if you want to use the onboard LEDs and Blue Switch on a F429ZI
//#define USEONBOARD

//Declare functions
void sw1FallingEdge();

//Global Objects
#ifdef USEONBOARD
DigitalOut  red_led(LED3);
DigitalOut  green_led(LED1);
InterruptIn sw1(USER_BUTTON);
#else
DigitalOut  red_led(D7);
DigitalOut  green_led(D5);
InterruptIn sw1(D4);
#endif

//Interrupt service routine for a rising edge (press)
void sw1FallingEdge() {
    red_led = !red_led;     //Toggle the LED
}

Serial pc(USBTX, USBRX);

//Main - only has to initialise and sleep
int main() {

    pc.set_blocking(true);
    red_led   = 0;
    green_led = 1;
    
    //Configure interrupts, wait for first rising edge
    sw1.fall(&sw1FallingEdge);
    
    //Main Polling Loop
    while (true) {
        
        //Put CPU back to sleep
        sleep();
        
        //You can ONLY reach this point if an ISR wakes the CPU
        green_led = !green_led;
        
        //Any use of the serial port will produce a series of interrupts
        //pc.puts("Ping!\n\r");
        
    } //end while

}
