#include "mbed.h"
//
// Coursework Template 1.0
//
// Please clone and edit as appropriate. Please read comments below.
//
//
// Function declarations
void POST(); 

//*****************************************************************************
// 1. COMMENT OUT THIS LINE FOR YOUR OWN CODE
#define SOFT261_MAY18_HARDWARE_CHECK
// ****************************************************************************
 
#ifdef SOFT261_MAY18_HARDWARE_CHECK
//Hardware declarations for the full power-on self test.
DigitalOut redLed(D7);
DigitalOut yellowLed(D6);
DigitalOut greenLed(D5);
DigitalIn sw1(D4);
DigitalIn sw2(D3);
AnalogIn adcIn(A0);
int main() { 
    POST(); 
    while (true) {
           redLed = 1;
           wait(0.2);
           redLed = 0;
           wait(0.2);     
    }
}
#else
// ****************************************************************************
// 2. Declare your driver objects here - some are done for you
// ****************************************************************************
DigitalOut redLed(D7);
DigitalOut yellowLed(D6);
DigitalOut greenLed(D5);
AnalogIn adcIn(A0);


// ****************************************************************************
// 3. Write task code here
// ****************************************************************************
    
//Main function - your entry point and often main loop
int main()
{
    POST(); //Power on self test - you can leave this here if you wish

    //Infinite loop (you may remove if you wish)
    while (true) {
        //TODO: Write Code   
    }
}
#endif








// ***************************************************************************
// No changes beyond this point
// ***************************************************************************

//
// POWER ON SELF TEST (POST)
#ifdef SOFT261_MAY18_HARDWARE_CHECK
void POST() {
    //Check serial interface is configured
    puts("Checking serial communications with PuTTY");

    //Check switches
    puts("Press switches now");
    wait(1.0);
    int s1 = sw1;
    int s2 = sw2;
    printf("Switch 1 state = %s\n", (s1 == 1) ? "PRESSED" : "RELEASED");
    printf("Switch 2 state = %s\n", (s2 == 1) ? "PRESSED" : "RELEASED");
    puts("Release the switches");
    wait(1.0);
    s1 = sw1;
    s2 = sw2;
    printf("Switch 1 state = %s\n", (s1 == 1) ? "PRESSED" : "RELEASED");
    printf("Switch 2 state = %s\n", (s2 == 1) ? "PRESSED" : "RELEASED");

    //Check LEDs
    puts("Checking LEDs");
    for (unsigned int n=0; n<5; n++) {
        puts("red");
        redLed    = 1;
        yellowLed = 0;
        greenLed  = 0;
        wait(0.2);
        puts("yellow");
        redLed    = 0;
        yellowLed = 1;
        greenLed  = 0;
        wait(0.2);
        puts("green");
        redLed    = 0;
        yellowLed = 0;
        greenLed  = 1;
        wait(0.2);
    }
    //Check switches
    greenLed = 0;

    //Finally the ADC
    puts("Check ADC - turn potentiometer");
    wait(1.0);
    float v = adcIn;
    printf("vin = %.4f\n", v);
    puts("Check ADC - turn potentiometer again");
    wait(1.0);
    v = adcIn;
    printf("vin = %.4f\n", v);
    puts("DONE.");
}
#else
void POST() {
    puts("Checking serial communications with PuTTY");
    redLed = 1;
    yellowLed = 1;
    greenLed = 1;
}
#endif