#include "mbed.h"
#include <math.h>
#include "USBMouse.h"
#include "USBKeyboard.h"
DigitalOut led(LED1);
DigitalIn  sw1(USER_BUTTON);
USBMouse mouse;     //Default - relative movement

int main(void)
{
    uint16_t x_center = (X_MAX_ABS - X_MIN_ABS)/2;
    uint16_t y_center = (Y_MAX_ABS - Y_MIN_ABS)/2;
    int16_t x_screen = 0;
    int16_t y_screen = 0;

    uint32_t x_origin = x_center;
    uint32_t y_origin = y_center;
    
    float angle = 0.0;

    //set to good known state
    mouse.update(x_origin, y_origin, 0, 0);

    while (1) {
        x_screen = 5.0f * cos((double)angle*3.14/180.0);
        y_screen = 5.0f * sin((double)angle*3.14/180.0);

        mouse.move(x_screen, y_screen);
        angle += 3.0f;
        wait(0.01);
    }
}
