#include "mbed.h"
#include "TextLCD.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "sample_hardware.hpp"



//#define BME
#ifdef BME
#include "BME280.h"
#else
#include "BMP280.h"
#endif

//LCD Driver
//RS D9
//E  D8
//D7,6,4,2 are the 4 bit for d4-7
TextLCD lcd(D9, D8, D7, D6, D4, D2); // rs, e, d4-d7
SDBlockDevice sd(PB_5, D12, D13, D10); // mosi, miso, sclk, cs
 
int main() {
    //Greeting
    lcd.printf("Testing\n\n");    
    
    //Power on self test
    post();
    
    //Initialise the SD card
    if ( sd.init() != 0) {
        printf("Init failed \n");
        errorCode(FATAL);
    } 
    
    //Create a filing system for SD Card
    FATFileSystem fs("sd", &sd);     

    //Open to WRITE
    FILE* fp = fopen("/sd/test.csv","a");
    if (fp == NULL) {
        error("Could not open file for write\n");
        errorCode(FATAL);
    }
            
    //Press either switch to unmount
    while ((SW1 == 0) && (SW2 == 0)) {
        double temp = sensor.getTemperature();
        double pressure = sensor.getPressure();
        lcd.printf("Temp   Pressure\n"); 
        lcd.printf("%6.1f ",temp);
        lcd.printf("%.2f\n",pressure);
        
        //Write to SD
        fprintf(fp, "%6.1f,%.2f\n\r", temp, pressure);
        
        wait(1.0);
    }
    
    //Close File
    fclose(fp);
    
    //Close down
    sd.deinit();
    printf("Unmounted...\n");
    lcd.cls();
    lcd.printf("Unmounted...\n\n");
    
    //Flash to indicate goodness
    while(true) {
        greenLED = 1;
        wait(0.5);
        greenLED = 0;
        wait(0.1);    
    }
}


    
