#include "mbed.h"
SPI ser_port(p11, p12, p13);    // mosi, miso, sclk, ssel
DigitalOut cs(p14);        //this acts as “slave select”  
Serial pc(USBTX, USBRX);
DigitalIn echo(p20);
DigitalOut trigger(p19);
DigitalIn echo1(p18);
DigitalOut trigger1(p17);
DigitalIn echo2(p16);
DigitalOut trigger2(p15);
DigitalOut greenled(p21);
DigitalOut redled(p22);
DigitalOut yellowled(p23);
char switch_word ; //word we will send

Timer t;
float i,j,k;

int main() 
{
    ser_port.format(8,0); 
    ser_port.frequency(4000000); 
    t.start(); //start timer  
    while(1) 
    {
        trigger = 1;
        wait_ms(1); 
        trigger=0; //stop sending pulses 
        while(!echo); //listen for echo pulse 
        t.reset(); //reset timer to measure echo pulse width 
        while(echo); 
        i=t.read_us(); //attach i to echo pulse width of sensor 1 in us
         
        trigger1 = 1;
        wait_ms(1); 
        trigger1=0; //stop sending pulses 
        while(!echo1); //listen for echo pulse 
        t.reset(); //reset timer to measure echo pulse width 
        while(echo1); 
        j=t.read_us(); //attach i to echo pulse width of sensor 1 in us
        
        trigger2 = 1;
        wait_ms(1); 
        trigger2=0; //stop sending pulses 
        while(!echo2); //listen for echo pulse 
        t.reset(); //reset timer to measure echo pulse width 
        while(echo2); 
        k=t.read_us(); //attach i to echo pulse width of sensor 1 in us

        i=i/58; //converting to cm
        j=j/58;
        k=k/58;
        pc.printf("Distance of i\n\r");
        pc.printf("%1.3f \n\r",i);
        wait(0.10);
        pc.printf("Distance of j\n\r");
        pc.printf("%1.3f \n\r",j);
        wait(0.10);
        pc.printf("Distance of k\n\r");
        pc.printf("%1.3f \n\r",k);
        wait(0.10);
        
        greenled = 0; 
        redled = 0; 
        yellowled = 0;
        
        switch_word=0xF0; //set up a recognisable output pattern
        if((i>75) &&(j>75)&&(k>75)){ // condition for no obstacle
        switch_word=switch_word|0x00; //move forward
        }
        if((i<75)&&(j>75)&&(k>75)){ //sensor 1 senses obstacle
        switch_word=switch_word|0x01; // obstacle in the centre; turn left
        yellowled=1;
        }
        if ((j<75)&&(i>75)&&(k>75)){
        switch_word=switch_word|0x02; // obstacle on the right; turn left
        greenled=1;
        }
        if((k<75)&&(j>75)&&(i>75)){
        switch_word=switch_word|0x03; // obstacle on the left; turn right
        redled=1;
        }
        if((i<75)&&(j<75)&&(k<75)){
        switch_word= switch_word|0x04; // no way clear; reverse
        greenled=1;
        redled=1;
        yellowled=1;
        }
        if((i<75)&&(j<75)&&(k>75)){
        switch_word= switch_word|0x05; // FR
        greenled=1;
        yellowled=1;
        }
        if((i<75)&&(k<75)&&(j>75)){
        switch_word= switch_word|0x06; // FL
        redled=1;
        yellowled=1;
        }
        cs = 0;                                //select slave
        ser_port.write(switch_word);  //send switch_word
        cs = 1;                 
        wait (0.000002);
    }
}