#include "mbed.h"

Serial pc(USBTX, USBRX);
Serial async_port(p9, p10);     //set up TX and RX on pins 9 and 10
PwmOut PWM1(p25);       //create a PWM output called PWM1 on pin 25
PwmOut PWM2(p26);
AnalogIn LDR_Fin(p17);          //Front LDR In
AnalogIn LDR_Rin(p18);          //Right LDR In
AnalogIn LDR_Bin(p19);          //Back LDR In
AnalogIn LDR_Lin(p20);          //Left LDR In
AnalogIn LDR_5in(p16);          //LDR_5

DigitalOut LED_F(p5);
DigitalOut LED_R(p6);
DigitalOut LED_B(p7);
DigitalOut LED_L(p8);
DigitalOut LED5_hi(p21);          //LED5_hi
DigitalOut LED5_lo(p22);          //LED5_lo
DigitalOut LED5_run(p23);         //LED5_run

char switch_word ;              //the word we will send
char recd_val;                  //the received value 

float LDR_Fdata;
float LDR_Rdata;
float LDR_Bdata;
float LDR_Ldata;
float LDR_5data;

int F;
int R;
int B;
int L;
int LDR5_hi;
int LDR5_lo;
int LDR5_run;

int main() 
{
    async_port.baud(9600);                  //set baud rate to 9600 (ie default) accept default format, of 8 bits, no parity                                     
    while(1)
    {
        LDR_Fdata=LDR_Fin*3.3;              //Convert Ain to Voltage value
        LDR_Rdata=LDR_Rin*3.3;
        LDR_Bdata=LDR_Bin*3.3;
        LDR_Ldata=LDR_Lin*3.3;   
        LDR_5data=LDR_5in*3.3;
        switch_word=0xf0;              
        if(LDR_5data>3)
        {
            LDR5_hi=1;
            LDR5_lo=0;
            LDR5_run=0;
        }
        else if(LDR_5data<1.5)
        {
            LDR5_hi=0;
            LDR5_lo=1;
            LDR5_run=0;
        }
        else
        {
            LDR5_hi=0;
            LDR5_lo=0;
            LDR5_run=1;
        }
        if(LDR5_hi==1)
        {
            LED_F=0;
            LED_R=0;
            LED_B=0;
            LED_L=0;
            LED5_hi=1;
            LED5_lo=0;
            LED5_run=0;
            switch_word=switch_word|0x09;
            async_port.putc(switch_word);
            wait(1);
            PWM1=0.12;
            PWM2=0.12;
        }
        if(LDR5_lo==1)
        {
            LED_F=0;
            LED_R=0;
            LED_B=0;
            LED_L=0;
            LED5_hi=0;
            LED5_lo=1;
            LED5_run=0;
            switch_word=switch_word|0x00;
            async_port.putc(switch_word);
            PWM1=0.03;
            PWM2=0.026;
        } 
        if(LDR5_run==1)
        {
            recd_val=0;
            LED5_hi=0;
            LED5_lo=0;
            LED5_run=1;
            PWM1=0.03;
            PWM2=0.026;
            if(LDR_Fdata>LDR_Bdata)             //Block 1 - Check between F&B, L&R and set flags
            {
                F=1;
                B=0;                
            }                
            else if(LDR_Fdata<LDR_Bdata)
            {
                F=0;
                B=1;               
            }
            if(LDR_Rdata>LDR_Ldata)
            {
                R=1;
                L=0;               
            }                
            else if(LDR_Rdata<LDR_Ldata)
            {
                R=0;
                L=1;               
            }                                   //Block 1 - Finished
                
            if(F==1 && R==1)                    //Block 2 - Check according to flags and set LEDs/transmit direction
            {
                if(LDR_Fdata>LDR_Rdata)
                {
                    LED_F=1;
                    LED_R=0;
                    LED_B=0;
                    LED_L=0;
                    switch_word=switch_word|0x01;
                    async_port.putc(switch_word);
                }
                else if(LDR_Fdata<LDR_Rdata)
                {
                    LED_F=0;
                    LED_R=1;
                    LED_B=0;
                    LED_L=0;
                    switch_word=switch_word|0x03;
                    async_port.putc(switch_word);
                }
                else
                {
                    LED_F=1;
                    LED_R=1;
                    LED_B=0;
                    LED_L=0;
                    switch_word=switch_word|0x02;
                    async_port.putc(switch_word);
                }
            }
            if(F==1 && L==1)
            {
                if(LDR_Fdata>LDR_Ldata)
                {
                    LED_F=1;
                    LED_R=0;
                    LED_B=0;
                    LED_L=0;
                    switch_word=switch_word|0x01;
                    async_port.putc(switch_word);
                }
                else if(LDR_Fdata<LDR_Ldata)
                {
                    LED_F=0;
                    LED_R=0;
                    LED_B=0;
                    LED_L=1;
                    switch_word=switch_word|0x07;
                    async_port.putc(switch_word);
                }
                else
                {
                    LED_F=1;
                    LED_R=0;
                    LED_B=0;
                    LED_L=1;
                    switch_word=switch_word|0x08;
                    async_port.putc(switch_word);
                }
            }
            if(B==1 && R==1)
            {
                if(LDR_Bdata>LDR_Rdata)
                {
                    LED_F=0;
                    LED_R=0;
                    LED_B=1;
                    LED_L=0;
                    switch_word=switch_word|0x05;
                    async_port.putc(switch_word);
                }
                else if(LDR_Bdata<LDR_Rdata)
                {
                    LED_F=0;
                    LED_R=1;
                    LED_B=0;
                    LED_L=0;
                    switch_word=switch_word|0x03;
                    async_port.putc(switch_word);
                }
                else
                {
                    LED_F=0;
                    LED_R=1;
                    LED_B=1;
                    LED_L=0;
                    switch_word=switch_word|0x04;
                    async_port.putc(switch_word);
                }
            }         
            if(B==1 && L==1)
            {
                if(LDR_Bdata>LDR_Ldata)
                {
                    LED_F=0;
                    LED_R=0;
                    LED_B=1;
                    LED_L=0;
                    switch_word=switch_word|0x05;
                    async_port.putc(switch_word);
                }
                else if(LDR_Bdata<LDR_Ldata)
                {
                    LED_F=0;
                    LED_R=0;
                    LED_B=0;
                    LED_L=1;
                    switch_word=switch_word|0x07;
                    async_port.putc(switch_word);
                }
                else
                {
                    LED_F=0;
                    LED_R=0;
                    LED_B=1;
                    LED_L=1;
                    switch_word=switch_word|0x06;
                    async_port.putc(switch_word);
                }
            }                                   //Block 2 - Finished                
        }                                         
    }
}
