#include "mbed.h" //MASTER
#include "TextLCD.h"
 
TextLCD lcd(p19, p20, p21, p22, p23, p24, TextLCD::LCD20x4); // rs, e, d4-d7
I2C i2c_port(p28, p27);        // Configure a serial port, pins 9 and 10 are sda,scl
Serial async_port(p9, p10);             //set up TX and RX on pins 13 and 14   
SPISlave ser_port(p5, p6, p7, p8);    // mosi, miso, sclk
DigitalOut Front(LED1);
DigitalOut Right(LED2);
DigitalOut Back(LED3);
DigitalOut Left(LED4);

char switch_word;        //word we will send
char recd_val;            //value from async
char recd_val1;            //value from from Obstacle sensing
const int addr = 0x52;    // define the I2C slave address, an arbitrary even number
int Ob_R; 
int Ob_L;
int Ob_F;
int Ob_All;
int Ob_None;
int Ob_FR;
int Ob_FL;
int Light_Full;
int Light_None;
int Light_F;
int Light_FR;
int Light_R;
int Light_BR;
int Light_B;
int Light_BL;
int Light_L;
int Light_FL;

int main() 
{
    lcd.cls();
    lcd.locate(2,0);
    lcd.printf("Moon Buggy!");
    
    async_port.baud(9600);              //set baud rate to 9600 (ie default)
    
    ser_port.format(8,0); 
    ser_port.frequency(4000000); 
        
    while(1)
    {
        Front=0;                       //preset both to 0
        Right=0;
        Back=0;
        Left=0;
        Ob_FR=0;
        Ob_FL=0;
        Ob_F=0;
        Ob_R=0; 
        Ob_L=0;
        Ob_All=0;
        Ob_None=0;
        Light_Full=0;
        Light_None=0;
        Light_F=0;
        Light_FR=0;
        Light_R=0;
        Light_BR=0;
        Light_B=0;
        Light_BL=0;
        Light_L=0;
        Light_FL=0;
        
        //Block 1 Receive Obstacle Data and Set Flags

        if(ser_port.receive()) //test if data transfer has occurred
            recd_val1 = ser_port.read();   // Read byte from master
            recd_val1=recd_val1&0x0F;
            
        if (recd_val1==1)
        {
            Ob_F=1;
            lcd.locate(-4,3);
            lcd.printf("Obstacle Ahead");
        }
        if (recd_val1==2)
        {
            Ob_R=1;
            lcd.locate(-4,3);
            lcd.printf("Obstacle Right");
        }
        if (recd_val1==3)
        {
            Ob_L=1;
            lcd.locate(-4,3);
            lcd.printf("Obstacle Left ");
        }
        if (recd_val1==4)
        {
            Ob_All=1;
            lcd.locate(-4,3);
            lcd.printf("All Obstacles     ");
        }
        if (recd_val1==5)
        {
            Ob_FR=1;
            lcd.locate(-4,3);
            lcd.printf("Obstacles FR     ");
        }
        if (recd_val1==6)
        {
            Ob_FL=1;
            lcd.locate(-4,3);
            lcd.printf("Obstacles FL     ");
        }        
        if (recd_val1==0)
        {
            Ob_None=1;
            lcd.locate(-4,3);
            lcd.printf("No Obstacle     ");
        }

        //Block 2 Receive Light Data and Set Flags         
        if(async_port.readable()==1)    //is there a character to be read?
        recd_val=async_port.getc();     //if yes, then read it
        recd_val=recd_val&0x0f;         //AND out unwanted bits
        
        if(recd_val==0)
        {
            Front=0;
            Right=0;
            Back=0;
            Left=0;
            Light_None=1;
            //wait(0.5);
            lcd.locate(0,1);
            lcd.printf("No Light      ");
        }
        if(recd_val==9)
        {
            Front=1;
            Right=1;
            Back=1;
            Left=1;
            Light_Full=1;
            //wait(0.5);
            lcd.locate(0,1);
            lcd.printf("Full Light      ");
        }             
        if(recd_val==1)
        {
            Front=1;
            Light_F=1;
            //wait(0.5);
            lcd.locate(0,1);
            lcd.printf("Light Detected");
            lcd.locate(0,2);
            lcd.printf("  Front        ");
        }
        if(recd_val==2)
        {
            Front=1;
            Right=1;
            Light_FR=1;
            //wait(0.5);
            lcd.locate(0,1);
            lcd.printf("Light Detected");
            lcd.locate(0,2);
            lcd.printf("Front-Right");
        }
        if(recd_val==3)
        {
            Right=1;
            Light_R=1;
            //wait(0.5);
            lcd.locate(0,1);
            lcd.printf("Light Detected");
            lcd.locate(0,2);
            lcd.printf("  Right       ");
        }
        if(recd_val==4)
        {
            Back=1;
            Right=1;
            Light_BR=1;
            //wait(0.5);
            lcd.locate(0,1);
            lcd.printf("Light Detected");
            lcd.locate(0,2);
            lcd.printf("Back-Right");
        }
        if(recd_val==5)
        {
            Back=1;
            Light_B=1;
            //wait(0.5);
            lcd.locate(0,1);
            lcd.printf("Light Detected");
            lcd.locate(0,2);
            lcd.printf("  Back        ");
        }
        if(recd_val==6)
        {
            Back=1;
            Left=1;
            Light_BL=1;
            //wait(0.5);
            lcd.locate(0,1);
            lcd.printf("Light Detected");
            lcd.locate(0,2);
            lcd.printf("Back-Left");
        }
        if(recd_val==7)
        {
            Left=1;
            Light_L=1;
            //wait(0.5);
            lcd.locate(0,1);
            lcd.printf("Light Detected");
            lcd.locate(0,2);
            lcd.printf("  Left       ");
        }        
        if(recd_val==8)
        {
            Front=1;
            Left=1;
            Light_FL=1;
            //wait(0.5);
            lcd.locate(0,1);
            lcd.printf("Light Detected");
            lcd.locate(0,2);
            lcd.printf("Front-Left");
        }
        
        //Block 3 Compare Flags and Set Command
        switch_word=0xf0; 
        if(Light_F==1)
        {
            if(Ob_FR==1 || Ob_F==1)
            {
                //Go Left
                switch_word=switch_word|0x07;
            }
            if(Ob_FL==1)
            {
                //Go Right
                switch_word=switch_word|0x03;
            }
            if(Ob_All==1)
            {
                //Go Back
                switch_word=switch_word|0x05;
            }
            if(Ob_None==1 || Ob_R==1 || Ob_L==1)
            {
                //Go Front
                switch_word=switch_word|0x01;
            }
        }
        if(Light_R==1)
        {
            if(Ob_R==1)
            {
                //Go Front
                switch_word=switch_word|0x01;
            }
            if(Ob_FR==1)
            {
                //Go Left
                switch_word=switch_word|0x07;
            }                
            if(Ob_All==1)
            {
                //Go Back
                switch_word=switch_word|0x05;
            }
            if(Ob_None==1 || Ob_L==1 || Ob_F==1 ||Ob_FL==1)
            {
                //Go Right
                switch_word=switch_word|0x03;
            }
        }
        if(Light_L==1)
        {
            if(Ob_L==1)
            {
                //Go Front
                switch_word=switch_word|0x01;
            }
            if(Ob_FL==1)
            {
                //Go Right
                switch_word=switch_word|0x03;
            }                
            if(Ob_All==1)
            {
                //Go Back
                switch_word=switch_word|0x05;
            }
            if(Ob_None==1 || Ob_R==1 || Ob_F==1 ||Ob_FR==1)
            {
                //Go Left
                switch_word=switch_word|0x07;
            }
        }
        if(Light_B==1)
        {
            //Go Back
            switch_word=switch_word|0x05;
        }                  
        if(Light_Full==1)
        {
            //Stop
            switch_word=switch_word|0x09;
        }               
        if(Light_None==1)
        {
            //Stop
            switch_word=switch_word|0x00;
        }
        
        //Block 4 Send Command to Locomotion
        i2c_port.start();          //force a start condition
        i2c_port.write(addr);      //send the address
        i2c_port.write(switch_word); //send one byte of data, ie recd_val
        i2c_port.stop();           //force a stop condition
        wait(0.00000002);
    }    
}