/*******************************************************************************
    Université de Montpellier
    NemoSpace   IUT de Nîmes
    IniSat Modèle 1 Version 2
*******************************************************************************/
//  La lecture du GPS utilise une liaison série software

//      TP n°5 : Correction

//  Exo 1 : Enregistrement des coordonnées GPS sur carte SD
//  Exo 2 : Gestion de messages descendants (Supervision) et montants (Commande)
//  Exo 3 : Tracer sur My Maps votre déplacement autour du batiment (Mission)

#include "mbed.h"
//#include "platform/mbed_thread.h"
#include "SDFileSystem.h"

#include "system.h"
#include "user.h"
#include "soft_uart.h"
#include "gps.h"

SDFileSystem sd(PB_5, PB_4, PB_3, PA_11, "sd"); // MOSI, MISO, SCK, CS -> SPI pins on the Inisat

uint8_t etat, etat_mem;
uint16_t compteur;
float mes_accu;

int main()
{
    Init_System();
    etat = 0;
    Init_Soft_UART();
//    thread_sleep_for(1000);

// Setup a serial interrupt function to receive data
    
    wait_ms(1000);

    while (1) {
//        thread_sleep_for(1);        // Boucle toutes les 1 milliseconde environ
        wait_ms(1);
        compteur++;
        
//      Gestion des modes avec une machine d'états
        switch (etat) {
/******************************************************************************/
// Mode Init :      Mise sous tension
//                  Initialisation du µC
            case 0: {
                Init_User_Fonctions();
//                thread_sleep_for(1000);
                wait_ms(1000);
                Stop_Led();
                GPS_Init();
                Start_Led();
                Set_Led(Ve);
//                thread_sleep_for(1000);
                wait_ms(1000);
                etat = 1;
                break; }
/******************************************************************************/
//  Mode Gestion :  Gestion des actions
//                  Contrôle du système
            case 1:
                mes_accu = Mes_Bat();
                if(mes_accu < BAT_SEUIL_BAS_1) {
                    etat = 4;
                    Set_Led(Ro);
                } else {
                    etat = 2;
                    Set_Led(Ve);
                }
//                thread_sleep_for(1000);
                wait_ms(1000);
                break;
/******************************************************************************/
//  Mode Mission :  Acquisition de données
//                      Mesure Batterie
//                      Mesure Courant faces solaires
//                      Stockage
            case 2: 
                Lect_GPS();
                GPS_Decodage();
                Mes_SP();
                Mes_Temp();
                mes_accu = Mes_Bat();
                if(mes_accu > BAT_SEUIL_HAUT_1)
                {
                    etat = 3;
                    Set_Led(Ro_Ve);
                }
                else
                {
                    etat = 1;
                }
//                thread_sleep_for(1000);
//                wait_ms(1000);
                break;
/******************************************************************************/
//  Mode Radio :    Transmission de données
//                  Mise en forme pour affichage
            case 3:
                Envoi_GPS();
                Envoi_Mes_Bat();
//                Envoi_Mes_SP();
//                Envoi_Mes_Temp();
                
//                thread_sleep_for(1000);
//                wait_ms(1000);
                etat = 1;
                break;
/******************************************************************************/
//  Mode Survie :   Attente recharge de l'accu

            case 4:
                mes_accu = Mes_Bat();
                if(mes_accu < BAT_SEUIL_BAS_2) {
                    etat = 5;
                    Stop_User_Fonctions();
                }

                if(mes_accu > BAT_SEUIL_HAUT_1) {
                    etat = 1;
                    Set_Led(Ve);
                }
                break;
/******************************************************************************/
//  Mode Zombie :   Coupure des consommateurs
//                  Passage en mode faible consommation
//                  Diminution de la fréquence du CPU
//                  Passage en mode Sleep
            case 5:
                sleep();
                mes_accu = Mes_Bat();
                if(mes_accu > BAT_SEUIL_HAUT_1)
                    etat = 0;
                break;
/******************************************************************************/
            default:
                etat = 0;
                break;
/******************************************************************************/
        }   // end switch
/*        if(etat != etat_mem)            //  Debug des états
        {
            pc.printf("Etat_%d\r\n",etat);
            etat_mem = etat;
        }*/
/******************************************************************************/
    }   // end while
}   // end main
/******************************************************************************/
