/*******************************************************************************
    user.h -> fichier de fonctions

    Gestion des 2 DELs de la carte CPU
    Mesure tension batterie
    Mesure courant panneaux solaires
    Mesure température
*******************************************************************************/
//  Initialistion du µC, Tests divers
/**
*   @param null
*/
void Init_System(void) {   
//  Hello World
    pc.printf("\r\nIniSat V2 : TP5\r\n\n");
    
//  Test de l'horloge Systeme
//   pc.printf("Horloge CPU a %d Hz\r\n", SystemCoreClock);

    xbee.baud(38400); 
}
/******************************************************************************/
//  Gestion des 2 Dels de la carte CPU
Ticker Compteur_Led;
uint16_t cmpt_led;
uint8_t etat_led;
enum {Off, Ro, Ve, Ro_Ve} couleur;

void Tache_Cmpt_Led(void) {
    cmpt_led++;
    if(cmpt_led >= 100) {        // Période : 1 sec
        cmpt_led = 0;
        DEL_R = etat_led & 1;
    }
    else if(cmpt_led == 5) {
        DEL_R = 0;
    }
    else if(cmpt_led == 50) {
        DEL_V = etat_led & 2;
    }
    else if(cmpt_led == 60) {
        DEL_V = 0;
    }
}

void Init_Led(void) {
    cmpt_led = 0;
    etat_led = 0;
    Compteur_Led.attach(&Tache_Cmpt_Led,0.01);      // 10ms
}

void Start_Led(void) {
    Compteur_Led.attach(&Tache_Cmpt_Led,0.01);      // 10ms
}

void Stop_Led(void) {
    Compteur_Led.detach();
}

void Set_Led(uint8_t couleur) {
    etat_led = couleur;
}
/******************************************************************************/
//  Mesure de la tension de la batterie
float mes_bat;

float Mes_Bat(void) {
    
    mes_bat = batin.read()*4.59f + 0.31f;        // 3.3 x 13.9/10 + 310mV(D2 carte EPS)
    return mes_bat;
}

void Envoi_Mes_Bat(void) {
    
    pc.printf("BAT: %.2f V\n",mes_bat);     // Format pour Terminal (Putty)
}

void XBee_Envoi_Mes_Bat(void) {
    
    xbee.printf("#B%d\n",(uint16_t)(mes_bat*100));          // Format pour Supervision sans fil par XBee
}
/******************************************************************************/
//  Mesure des courants des 2 panneaux solaires
float mes_sp1, mes_sp2;

void Mes_SP(void) {

    mes_sp1 = sp_1in.read()*165.0f;           // 3.3 x 50
    mes_sp2 = sp_2in.read()*165.0f;           // 3.3 x 50
}

void Envoi_Mes_SP(void) {
    
    pc.printf("SP1: %.1f mA\tSP2: %.1f mA\n",mes_sp1,mes_sp2);
}
/******************************************************************************/
//  Fonction pour initialiser les fonctions précédentes

void Init_User_Fonctions(void) {
    
    ctrl_reg = 1;       // Pour mettre sous tension le moniteur de courant des Solar Panels
    Init_Led();
}
//  Fonction pour stopper les fonctions précédentes

void Stop_User_Fonctions(void) {
    
    ctrl_reg = 0;
    Stop_Led();
}
/******************************************************************************/
//  Mesure de la température
float mes_temp;

void Mes_Temp(void) {

    mes_temp = (tempin.read()*3.3f-0.5f)/0.01f;        // 3.3 x -500mV
}

void Envoi_Mes_Temp(void) {
    
    pc.printf("Temp: %.1f degC\r\n",mes_temp);          // Mesure directe
}

void XBee_Envoi_Mes_Temp(void) {
    
    xbee.printf("#T%d\n",(uint16_t)(mes_temp*10));          // Supervision -> par XBee
}
/******************************************************************************/

                