/*******************************************************************************
    Université de Montpellier
    NemoSpace   IUT de Nîmes
    IniSat Modèle 1 Version 2
*******************************************************************************/
//  La lecture du GPS utilise une liaison série software

//      TP n°5 : Correction

//  Exo 1 : Enregistrement des coordonnées GPS sur carte SD
//  Exo 2 : Gestion de messages descendants (Supervision) et montants (Commande)
//  Exo 3 : Tracer sur My Maps votre déplacement autour du batiment (Mission)

#include "mbed.h"
//#include "platform/mbed_thread.h"
#include "SDFileSystem.h"

#include "system.h"
#include "user.h"
#include "soft_uart.h"
#include "gps.h"

SDFileSystem sd(PB_5, PB_4, PB_3, PA_11, "sd"); // MOSI, MISO, SCK, CS -> SPI pins on the Inisat

uint8_t etat, etat_mem;
uint16_t compteur;
float mes_accu;

uint8_t xb_ptr;
char xb_buf[10], cmd[3], param[10];

void Rx_interrupt(void);

int main()
{
    Init_System();
    etat = 0;
    Init_Soft_UART();
//    thread_sleep_for(1000);
    xb_ptr = 0;
    cmd[0] = 'P';           // Controle montant par PC
// Setup a serial interrupt function to receive data
    xbee.attach(&Rx_interrupt, Serial::RxIrq);
    __enable_irq();
    
    wait_ms(1000);

    while (1) {
//        thread_sleep_for(1);        // Boucle toutes les 1 milliseconde environ
        wait_ms(1);
        compteur++;
        
//      Gestion des modes avec une machine d'états
        switch (etat) {
/******************************************************************************/
// Mode Init :      Mise sous tension
//                  Initialisation du µC
            case 0: {
                Init_User_Fonctions();
//                thread_sleep_for(1000);
                wait_ms(1000);
                Stop_Led();
                GPS_Init();
                Start_Led();
                Set_Led(Ve);
                
//  Création d'un fichier "gps_data.txt" sur la carte SD    
    FILE *fp = fopen("/sd/gps_data.txt", "w");
    if(fp == NULL) {
        error("Erreur : fichier non accessible en ecriture\n");
    }
    pc.printf("Carte SD Ok!\r\n");
    xbee.printf("Station Sol par XBee Ok!\r\n");

//  Write text in file    
 //   fprintf(fp, "Hello World, greats from Inisat!");
 //   pc.printf("Write some words in sdtest.txt on sd/mydir directory\r\n"); 
        
//  Close file    
    fclose(fp); 
//                thread_sleep_for(1000);
                wait_ms(1000);
                etat = 1;
                break; }
/******************************************************************************/
//  Mode Gestion :  Gestion des actions
//                  Contrôle du système
            case 1:
                mes_accu = Mes_Bat();
                if(mes_accu < BAT_SEUIL_BAS_1) {
                    etat = 4;
                    Set_Led(Ro);
                } else {
                    etat = 2;
                    Set_Led(Ve);
                }
//                thread_sleep_for(1000);
                wait_ms(1000);
                break;
/******************************************************************************/
//  Mode Mission :  Acquisition de données
//                      Mesure Batterie
//                      Mesure Courant faces solaires
//                      Stockage
            case 2: 
                Lect_GPS();
                GPS_Decodage();
                Mes_SP();
                Mes_Temp();
                mes_accu = Mes_Bat();
                if(mes_accu > BAT_SEUIL_HAUT_1)
                {
                    etat = 3;
                    Set_Led(Ro_Ve);
                }
                else
                {
                    etat = 1;
                }
//                thread_sleep_for(1000);
//                wait_ms(1000);
                break;
/******************************************************************************/
//  Mode Radio :    Transmission de données
//                  Mise en forme pour affichage
            case 3:
                switch (cmd[0]) {     // Commn
                    case 'P': {         // Commande montante filaire
                        Envoi_GPS();
                        Envoi_Mes_Bat();
//                      Envoi_Mes_SP();
                        Envoi_Mes_Temp();
                        break; }
                    case 'X':           // Commande montante sans fil par XBee
                        XBee_Envoi_GPS();
                        XBee_Envoi_Mes_Bat();
//                        XBee_Envoi_Mes_SP();
                        XBee_Envoi_Mes_Temp();
                        break;
                    default:
                        cmd[0] = 'P';
                        break;
                }
                etat = 1;
                break;
/******************************************************************************/
//  Mode Survie :   Attente recharge de l'accu

            case 4:
                mes_accu = Mes_Bat();
                if(mes_accu < BAT_SEUIL_BAS_2) {
                    etat = 5;
                    Stop_User_Fonctions();
                }

                if(mes_accu > BAT_SEUIL_HAUT_1) {
                    etat = 1;
                    Set_Led(Ve);
                }
                break;
/******************************************************************************/
//  Mode Zombie :   Coupure des consommateurs
//                  Passage en mode faible consommation
//                  Diminution de la fréquence du CPU
//                  Passage en mode Sleep
            case 5:
                sleep();
                mes_accu = Mes_Bat();
                if(mes_accu > BAT_SEUIL_HAUT_1)
                    etat = 0;
                break;
/******************************************************************************/
            default:
                etat = 0;
                break;
/******************************************************************************/
        }   // end switch
/*        if(etat != etat_mem)            //  Debug des états
        {
            pc.printf("Etat_%d\r\n",etat);
            etat_mem = etat;
        }*/
/******************************************************************************/
    }   // end while
}   // end main
/******************************************************************************/
void Rx_interrupt(void) {
    if(xbee.readable())
    {
        xb_buf[xb_ptr] = xbee.getc();
        
        if((xb_buf[xb_ptr] == 0x0A) || (xb_buf[xb_ptr] == 0x0D))      // Test touche entrée en mode ASCII
        {
            xb_buf[xb_ptr] = 0;         // Transforme le tableau en chaine de caractères  
            xb_ptr = 0;
            if (xb_buf[0] == '$')        // Entete de message valide
            {
                cmd[0] = xb_buf[1];
                xbee.printf("#%c\r\n",cmd[0]+0x20);       // Acquittement
                param[0] = xb_buf[2];
            }
//                xb_ok = 1;                      // Trame disponible pour décodage
//                pc.printf("%s\n\r",buffer);     // Echo  
        }
        else {
            xb_ptr++;
        }  
    }
}