/*******************************************************************************
    system.h -> fichier de configuration

    Lignes en Entrées/Sorties
    Lignes en Entrées analogiques
    Lignes associées aux bus (série, I2C, SPI)
*******************************************************************************/

Serial pc(USBTX, USBRX);            // Dialogue UART par USB à 9600 Baud sur carte Nucléo

DigitalOut DEL(LED1);               // Ligne PB_3 sur la carte Nucléo
DigitalOut DEL_R(PB_0);             // DEL rouge sur carte CPU
DigitalOut DEL_V(PB_1);             // DEL verte sur carte CPU

DigitalOut ctrl_reg(PA_12);         // Controle du régulateur 3.3V sur carte EPS

AnalogIn   batin(PA_0);             // Mesure tension batterie sur carte EPS
AnalogIn   sp_1in(PA_6);            // Mesure courant Solar Panel 1 sur carte EPS
AnalogIn   sp_2in(PA_5);            // Mesure courant Solar Panel 2 sur carte EPS

//  Divers seuils pour la batterie
#define BAT_SEUIL_HAUT_2 4.2f
#define BAT_SEUIL_HAUT_1 3.9f
#define BAT_SEUIL_BAS_1 3.5f
#define BAT_SEUIL_BAS_2 3.3f

