/*******************************************************************************
    Université de Montpellier
    NemoSpace   IUT de Nîmes
    IniSat Modèle 1 Version 2
*******************************************************************************/
//      TP n°3 : Trame pour débuter

//  Exo 1 : Lecture tension batterie
//  Exo 2 : Lecture courants faces solaires
//  Exo 3 : Modes de fonctionnement

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "system.h"
#include "user.h"

uint8_t etat, etat_mem;
float mes_accu;
uint16_t tick_UART;

int main() {
    
    Init_System();
    etat = 0;
    tick_UART = 500;

    while (1) {
        thread_sleep_for(1);        // Boucle toutes les 1 milliseconde environ
        
//      Gestion des modes avec une machine d'états      
        switch (etat)
        {
/******************************************************************************/
// Mode Init :      Mise sous tension
//                  Initialisation du µC

            case 0:
//                ctrl_reg = 1;
                thread_sleep_for(1000);
                    etat = 3;
                etat = 1;
                break;
/******************************************************************************/            
//  Mode Gestion :  Gestion des actions
//                  Contrôle du système

            case 1:
                mes_accu = batin.read()*4.587f + 0.31f;     // 3.3 * 1.39
                if(!tick_UART--)
                {
                    tick_UART = 500;
                    pc.printf ("Bat: %.2fV\r\n",mes_accu);
                }
                if(mes_accu < BAT_SEUIL_BAS_1)
                    etat = 4;
                else
                    etat = 2;
                break;
/******************************************************************************/            
//  Mode Mission :  Acquisition de données (Mesure Courant faces solaires)
//                  Stockage

            case 2:
                thread_sleep_for(1000);
                    etat = 3;
                break;
/******************************************************************************/             
//  Mode Radio :    Transmission de données

            case 3:
                thread_sleep_for(1000);
                    etat = 1;
                break;  
/******************************************************************************/             
//  Mode Survie :   Attente recharge de l'accu
                    
            case 4:
                mes_accu = batin.read()*4.587f + 0.31f;     // 3.3 * 1.39

                if(mes_accu < BAT_SEUIL_BAS_2)
                    etat = 5;
                if(mes_accu > BAT_SEUIL_HAUT_1)
                    etat = 1;    
                break;
/******************************************************************************/
//  Mode Zombie :   Coupure des consommateurs
//                  Passage en mode faible consommation
//                  Diminution de la fréquence du CPU
//                  passage en mode Sleep

            case 5:
//                ctrl_reg = 0;
                mes_accu = batin.read()*4.587f + 0.31f;     // 3.3 * 1.39

                if(mes_accu > BAT_SEUIL_HAUT_1)
                    etat = 0; 
                break;
/******************************************************************************/
            default:
                etat = 0;
                break;
/******************************************************************************/          
        }   // end switch
        if(etat != etat_mem)            //  Debug des états
        {
            pc.printf("Etat_%d\r\n",etat);
            etat_mem = etat;
        }
    }   // end while
}   // end main
/******************************************************************************/  