//#ifndef mydati_h
//#odefine mydati_h
#include "mbed.h"



Serial pc(USBTX, USBRX); // tx, rx

#ifndef mydati_h
#define mydati_h
extern Serial pc;
extern Serial device;
extern Serial device2;

namespace  mydati{

bool pc_trasmisione(int,char* s);

    struct pacco{
    char* txt;
    char n;
    };
    
class trasmetti{ /* classe superiore che ha il compito di interagire con l' altra scheda,
                 le altre sottoclassi si intrfacciano a lei */
private:
    int addr_slave;
    I2C* master;
    char conteggio;

    struct coda{
    char priorita;
    pacco* dato;
    coda* suc;
    };
    coda* testa;
    coda* fine;
    char n;
    void extract(pacco**);
public:
trasmetti():n(0){testa=fine=0;}

void set_add(int a){addr_slave=a;}
void set_master(I2C* a){master=a;}

bool ins_in_coda(pacco* ,char priorita= 0);
bool ins_priorita(pacco* ,char priorita= 0);
bool ins_in_testa(pacco* ,char priorita= 0);

bool pc_trasmisione(int n,char* s);

bool invio();
}
//serve perche deve essere unina per tutti e quindi di variabile di qeusta classe ne deve essere creata solo una
#ifdef tra_cpp 
telemetria;
#else
;
extern trasmetti telemetria;
#endif
class sensore{ //classe generia appezotata, da riempire sucesivamente per oblicare alle altri figlie di implemetare la funzione
    private:
    static const int max_n=10;
    int n;
    
    public:
    sensore():n(-1){}
    virtual bool invia(char p=0)=0;
    int number(){n++;n=n%max_n;return n;}
    virtual ~sensore(){}
};


/*le sucesive classi hanno il compito di legere i dati dal sensore 
e di inviari interfaciandosi con la classe di sopra, 
le funzioni che prendoi i dati vengono cambiate, c'è un set_all che viene implementato in mbed, 
l' altro serve a me per testare il tutto con il cp
*/
class dati_imu : public sensore{
private:
static const char priorita_imu =5;
static const int nb_classe =25;
    float ax,ay,az;
    float gx,gy,gz;
    float pich,roll,yaw;
    float temp;
    static const int off_set_a=2000;
    static const int off_set_g=1000;
public:
//dati_imu():sensore(),ax(0),ay(0),az(0),gx(0),gy(0),gz(0),pich(0),roll(0),yaw(0),temp(0){}

void set_all(float a,float b,float c,float d,float e,float f,float g,float h, float i, float t){ // da elimiare i parametri di ingresso, essa chiamera una funzione dedicata
    ax=a;ay=b;az=c;gx=d;gy=e;gz=f;pich=g;roll=h;yaw=i;temp=t;   
    }
void set_all(); 

virtual bool invia(char p=priorita_imu);
};

class estensimetro : public sensore{
    private:
        static const char priorita_estensimetro =4;
        static const int nb_classe =17;
        float ad,as,pd,ps; // a= anteriore p= posteriore
    public:
        void set_all(float vad,float vas,float vpd,float vps){ad=vad; as=vas; pd=vpd; ps=vps;}
        void set_all(); 
        virtual bool invia(char p=priorita_estensimetro);
};

class ruota_fonica : public sensore{
    private:
        static const char priorita_ruota_fonica =4;
        static const int nb_classe =17;
        float ad,as,pd,ps; // a= anteriore p= posteriore
    public:
        void set_all(float vad,float vas,float vpd,float vps){ad=vad; as=vas; pd=vpd; ps=vps;}
        void set_all(){}
        virtual bool invia(char p=priorita_ruota_fonica);
};

class motore : public sensore{
    private:
        static const char priorita_motore =4;
        static const int nb_classe =24;
        float  P_olio,RMP,velocita;
        char marcia,T_acqua,T_olio;
    public:
        motore():P_olio(0),RMP(0),velocita(0),marcia(0),T_acqua(0),T_olio(0){}
        void set_all(char Ta,char To,float Po,float vrmp,float vel, char m){T_acqua=Ta; T_olio=To;P_olio=Po;RMP=vrmp;velocita=vel;marcia=m;}
        void set_1(float a,char b){RMP=a;T_acqua=b;}
        void set_velocita_gear(float a,char b){velocita=a;marcia=b;}
        void set_T_oil(char a){T_olio=a;}
        void set_P_oil(float a){P_olio=a;}
        
        char get_marcia()const{return marcia;}
        char get_Tacq()const{return T_acqua;}
        char get_Tolio()const{return T_olio;}
        float get_Polio()const{return P_olio;}
        float get_rmp()const{return RMP;}
        float get_vel()const{return velocita;}
        
        virtual bool invia(char p=priorita_motore);
};

class allert{
    public:
    bool invia(const char*);
};
#ifdef tra_cpp 

void led_rpm(int rpm, char a[]){
    
    int r=rpm;

    if(r==0)a[0]=a[1]=0xff;
    else if(r<3000){a[0]=0xfb;a[1]=0xef;}
    else if(r<(3000+1333)){a[0]=0xf3;a[1]=0b11001111;}
    else if(r<(3000+1333*2)){a[0]=0xe3;a[1]=0b11000111;}
    else if(r<(3000+1333*3)){a[0]=0xc3;a[1]=0b11000011;}
    else if(r<(3000+1333*4)){a[0]=0x83;a[1]=0b11000001;}
    else if(r<(3000+1333*5)){a[0]=0x03;a[1]=0b11000000;}
    else if(r<(11000)){a[0]=0x01;a[1]=0b10000000;}
    else {a[0]=0x00;a[1]=0x00;}
}


bool trasmetti::pc_trasmisione(int n,char* s)
{// da implementae con funzione che invia i dati su
char ss[30];

for(int i=0;i<20;i++)ss[5+i]='X';
strcpy(ss,s);


/*da portare in setting e trovare un modo epr farli risultare qui*/
const int addr = 0x70;
const int addr1 = 0x72;



char nn[2];

char a[2];

nn[0]=22;
int rpm;

//master->frequency(100000);//da portare in setting e non farlo sempre

//aggiungere condizione di return false se il write fallisce !
        wait_us(10);  
        
        master->write(addr_slave,ss,nn[0]);
        wait_us(1);
        master->stop();
        
        
  #define led_genny
    
    #ifdef led_genny
         if(s[0]=='D'){
            rpm=(s[7]-'0')*10000+(s[8]-'0')*1000+(s[9]-'0')*100+(s[10]-'0')*10+s[11]-'0';    
            led_rpm(rpm,a);
            master->write(addr, a, 1);    // Send command string
            master->stop();
            master->write(addr1, &a[1], 1);    // Send command string
            master->stop();
          }
        
        
   #endif     
        
    
    //  device.printf("%s@",s);
     // device2.printf("%s@",s);
     
      // pc.printf("%s\r\n",ss); 
         

return true;    
}
#endif
}
#endif