/* MPU6050 Basic Example Code
 by: Kris Winer
 date: May 1, 2014
 license: Beerware - Use this code however you'd like. If you 
 find it useful you can buy me a beer some time.
 
 Demonstrate  MPU-6050 basic functionality including initialization, accelerometer trimming, sleep mode functionality as well as
 parameterizing the register addresses. Added display functions to allow display to on breadboard monitor. 
 No DMP use. We just want to get out the accelerations, temperature, and gyro readings.
 
 SDA and SCL should have external pull-up resistors (to 3.3V).
 10k resistors worked for me. They should be on the breakout
 board.
 
 Hardware setup:
 MPU6050 Breakout --------- Arduino
 3.3V --------------------- 3.3V
 SDA ----------------------- A4
 SCL ----------------------- A5
 GND ---------------------- GND
 
  Note: The MPU6050 is an I2C sensor and uses the Arduino Wire library. 
 Because the sensor is not 5V tolerant, we are using a 3.3 V 8 MHz Pro Mini or a 3.3 V Teensy 3.1.
 We have disabled the internal pull-ups used by the Wire library in the Wire.h/twi.c utility file.
 We are also using the 400 kHz fast I2C mode by setting the TWI_FREQ  to 400000L /twi.h utility file.
 */
 #include "MPU6050.h"
void calcola_dati();
float sum = 0;
uint32_t sumCount = 0;

MPU6050 mpu6050;
Timer t;

Thread calcolo_q;

//void pc_trasmisione(int n,char* s);
bool inPosition=true;


#include "racolta_dati.h" 
  char buffer[100];


void main_imu() // prendere tutto questo main e meterno in main_imu, rinominarlo e aviorlo da qui.
{
  //  char n;     pacco posta;
  
    using namespace mydati;
     
      dati_imu myimu;
      





  //Set up I2C
  i2c.frequency(100000);  // use fast (400 kHz) I2C   
  t.start();        
  
 
        
        
  wait_ms(350);
  
    inPosition=pul;//vero se non è premuto
 if(inPosition)pc.printf("pulsante premuto!");
  
        // Read the WHO_AM_I register, this is a good test of communication
 uint8_t whoami = mpu6050.readByte(MPU6050_ADDRESS, WHO_AM_I_MPU6050);  // Read WHO_AM_I register for MPU-6050
 pc.printf("\t\tI AM 0x%x\n\n\r", whoami); pc.printf("I SHOULD BE 0x68\n\r");
 

  if (whoami == 0x68) // WHO_AM_I should always be 0x68
  {  
    pc.printf("MPU6050 is online...");
    wait_ms(50);
  

    
    mpu6050.MPU6050SelfTest(SelfTest); // Start by performing self test and reporting values
    pc.printf("x-axis self test: acceleration trim within : "); pc.printf("%d", SelfTest[0]); pc.printf("% of factory value \n\r");
    pc.printf("y-axis self test: acceleration trim within : "); pc.printf("%d", SelfTest[1]); pc.printf("% of factory value \n\r");
    pc.printf("z-axis self test: acceleration trim within : "); pc.printf("%d", SelfTest[2]); pc.printf("% of factory value \n\r");
    pc.printf("x-axis self test: gyration trim within : "); pc.printf("%d", SelfTest[3]); pc.printf("% of factory value \n\r");
    pc.printf("y-axis self test: gyration trim within : "); pc.printf("%d", SelfTest[4]); pc.printf("% of factory value \n\r");
    pc.printf("z-axis self test: gyration trim within : "); pc.printf("%d", SelfTest[5]); pc.printf("% of factory value \n\r");
    wait(1);

    if(inPosition && SelfTest[0] < 1.0f && SelfTest[1] < 1.0f && SelfTest[2] < 1.0f && SelfTest[3] < 1.0f && SelfTest[4] < 1.0f && SelfTest[5] < 1.0f) 
    {
    mpu6050.resetMPU6050(); // Reset registers to default in preparation for device calibration
    mpu6050.calibrateMPU6050(gyroBias, accelBias); // Calibrate gyro and accelerometers, load biases in bias registers  
    mpu6050.initMPU6050(); pc.printf("MPU6050 initialized for active data mode....\n\n\r"); // Initialize device for active mode read of acclerometer, gyroscope, and temperature

   
    wait(2);
    pc.printf("set acc : x= %f\t,y= %f\tz= %f\r\n;",accelBias[0],accelBias[1],accelBias[2]);
       }
    else
    {
    pc.printf("Device did not the pass self-test!\n\r");
 
  
      }
    }
    else
    {
    pc.printf("Could not connect to MPU6050: \n\n\r");
    pc.printf("%#x \n",  whoami);
 
 
   
        while(1) ; // Loop forever if communication doesn't happen
  }
    


 calcolo_q.start(calcola_dati);
 
 while(1) {
   
   wait_ms(100);
   
   sprintf(buffer,"\tax = %6.1f\tay = %6.1f\taz = %6.1f\t\t", 1000*ax,1000*ay,1000*az);
  //sprintf(buffer,"ciao");
   wait_ms(10);

   #if test
   
   
   //sprintf(buffer,"\tax = %6.1f\tay = %6.1f\taz = %6.1f  mg\t\t", 1000*ax,100*ay,100*az); 
    
    
    pc.printf("\tax = %6.1f", 1000*ax); 
    pc.printf(" ay = %6.1f", 1000*ay); 
    pc.printf(" az = %6.1f  mg\t\t", 1000*az); 

    pc.printf("gx = %6.1f", gx); 
    pc.printf(" gy = %6.1f", gy); 
    pc.printf(" gz = %6.1f  deg/s\t", gz);
   //  pc.printf("Yaw: %.2f , Pitch: %.2f, Roll: %.2f", yaw, pitch, roll);
     pc.printf("\t temperature = %.2f  C\n\r", temperature);     
    // pc.printf("q0 = %f\tq1 = %f\tq2 = %f\tq3 = %f\n\r", q[0],q[1],q[2],q[3]);
    
        n=strlen(buffer);
        posta.n=n+1;
    
        posta.txt=buffer;
        
     //   telemetria.ins_in_coda(&posta);
        
        wait_ms(1);
      // telemetria.invio();
        wait_ms(1);
    
 //   pc.printf("q0 = %f\tq1 = %f\tq2 = %f\tq3 = %f\n\r", q[0],q[1],q[2],q[3]);
 
 #endif
 
 
        myimu.set_all(ax,ay,az,gx,gy,gz,0,0,0,temperature);
        wait_ms(2);
        myimu.invia();
        wait_ms(2);
  //da sostituire con la funzione della classe sensore imu

        
        
        //myled= !myled;
}

}

