
void calcola_dati(){
    while(true){
    wait_us(20);
  // If data ready bit set, all data registers have new data
  if(mpu6050.readByte(MPU6050_ADDRESS, INT_STATUS) & 0x01) {  // check if data ready interrupt
    mpu6050.readAccelData(accelCount);  // Read the x/y/z adc values
    mpu6050.getAres();
    
    // Now we'll calculate the accleration value into actual g's
    ax = (float)accelCount[0]*aRes - accelBias[0];  // get actual g value, this depends on scale being set
    ay = (float)accelCount[1]*aRes - accelBias[1];   
    az = (float)accelCount[2]*aRes - accelBias[2];  
   
    mpu6050.readGyroData(gyroCount);  // Read the x/y/z adc values
    mpu6050.getGres();
 
    // Calculate the gyro value into actual degrees per second
    gx = (float)gyroCount[0]*gRes; // - gyroBias[0];  // get actual gyro value, this depends on scale being set
    gy = (float)gyroCount[1]*gRes; // - gyroBias[1];  
    gz = (float)gyroCount[2]*gRes; // - gyroBias[2];   

    tempCount = mpu6050.readTempData();  // Read the x/y/z adc values
    temperature = (tempCount) / 340. + 36.53; // Temperature in degrees Centigrade
   }  
   
    Now = t.read_us();
    deltat = (float)((Now - lastUpdate)/1000000.0f) ; // set integration time by time elapsed since last filter update
    lastUpdate = Now;
    
    sum += deltat;
    sumCount++;
    
    if(lastUpdate - firstUpdate > 10000000.0f) {
     beta = 0.04;  // decrease filter gain after stabilized
     zeta = 0.015; // increasey bias drift gain after stabilized
    }
    
   // Pass gyro rate as rad/s
  gx=(int)gx;gy=(int)gy;gz=(int)gz;
  
  ax=((int)10000*ax)/10000;
  ay=((int)10000*ay)/10000;
  az=((int)10000*az)/10000;
  
  q[0]=((int)10000*q[0])/10000;
    q[1]=((int)10000*q[1])/10000;
  q[2]=((int)10000*q[2])/10000;
  q[3]=((int)10000*q[3])/10000;
   
    mpu6050.MadgwickQuaternionUpdate(ax, ay,az, gx*PI/180.0f, gy*PI/180.0f, gz*PI/180.0f);

    // Serial print and/or display at 0.5 s rate independent of data rates
    delt_t = t.read_ms() - count;
    if (delt_t > 500) { // update LCD once per half-second independent of read rate
#if false
    pc.printf("\tax = %6.1f", 1000*ax); 
    pc.printf(" ay = %6.1f", 1000*ay); 
    pc.printf(" az = %6.1f  mg\t\t", 1000*az); 

    pc.printf("gx = %6.1f", gx); 
    pc.printf(" gy = %6.1f", gy); 
    pc.printf(" gz = %6.1f  deg/s\t\t\t", gz); 
     pc.printf("\t\t temperature = %f  C\n\r", temperature);     

    
 //   pc.printf("q0 = %f\tq1 = %f\tq2 = %f\tq3 = %f\n\r", q[0],q[1],q[2],q[3]);
 #endif
 //   pc.printf("q1 = %f\n\r", q[1]); pc.printf("q2 = %f\n\r", q[2]); pc.printf("q3 = %f\n\r", q[3]);      
    

     

    
  // Define output variables from updated quaternion---these are Tait-Bryan angles, commonly used in aircraft orientation.
  // In this coordinate system, the positive z-axis is down toward Earth. 
  // Yaw is the angle between Sensor x-axis and Earth magnetic North (or true North if corrected for local declination, looking down on the sensor positive yaw is counterclockwise.
  // Pitch is angle between sensor x-axis and Earth ground plane, toward the Earth is positive, up toward the sky is negative.
  // Roll is angle between sensor y-axis and Earth ground plane, y-axis up is positive roll.
  // These arise from the definition of the homogeneous rotation matrix constructed from quaternions.
  // Tait-Bryan angles as well as Euler angles are non-commutative; that is, the get the correct orientation the rotations must be
  // applied in the correct order which for this configuration is yaw, pitch, and then roll.
  // For more see http://en.wikipedia.org/wiki/Conversion_between_quaternions_and_Euler_angles which has additional links.
  
  //sbagliato -> da fare tutto da capo. usare solo l' accelerometro per pich e rol, lo yaw non serve.
  
    yaw   = atan2(2.0f * (q[1] * q[2] + q[0] * q[3]),2.0f *(q[0] * q[0] + q[1] * q[1] - q[2] * q[2] - q[3] * q[3]));   //<--- quel coglione ha sbagliato a scrive l' equazione con i quaternioni
    pitch = -asin(2.0f * (q[1] * q[3] - q[0] * q[2]));
    roll  = atan2(2.0f * (q[0] * q[1] + q[2] * q[3]),2.0f* (q[0] * q[0] - q[1] * q[1] - q[2] * q[2] + q[3] * q[3]));
    pitch *= 180.0f / PI;
    yaw   *= 180.0f / PI; 
    roll  *= 180.0f / PI;
    

 // pc.printf("Yaw, Pitch, Roll: %.2f %.2f %.2f", yaw, pitch, roll);
   //  pc.printf("\taverage rate = %f\n\r", (float) sumCount/sum);
      
  
    count = t.read_ms(); 
    sum = 0;
    sumCount = 0; 
    }
    }
}