#ifndef img_sd_h
#define img_sd_h



#define BLOCK_START_ADDR         0     /* Block start address      */  

#define BLOCKSIZE                512   /* Block Size in Bytes      */
#define NUM_OF_BLOCKS            2     /* Total number of blocks   */
#define BUFFER_WORDS_SIZE        ((BLOCKSIZE * NUM_OF_BLOCKS) >> 2) /* Total data size in bytes */

#include <mbed.h>

Serial pc(USBTX, USBRX); // tx, rx

void stampa_B(uint32_t b[],int n,int x,int y,int x0,int y0,int x_0,int y_0);
void riemp_B(uint32_t b[],int n,int x0,int y0,int x,int y);


void serializza_img(uint32_t** img ,int x,int y,uint64_t addr){
    
    int n_b=4*x*y/BLOCKSIZE +1;
    uint32_t Buffer[BLOCKSIZE];
    Buffer[0]=n_b;
    Buffer[1]=0;
    Buffer[2]=x;
    Buffer[3]=y;
    //  pc.printf("n_b= %d\r\n",n_b);
    riemp_B(&Buffer[4],124,0,0,x,y);
    if(sd.WriteBlocks(Buffer,addr, BLOCKSIZE, 1) == SD_OK)
                pc.printf("SD OK");
    int incx,incy;
    incx=128/y;
    incy=128%y;
    int x0,y0;
    x0=124/y;
    y0=124%y;
    for(int i=1;i<n_b;i++){
         // pc.printf("sto caricando il buffer..  ");
          riemp_B(Buffer,128,x0,y0,x,y);
          if(sd.WriteBlocks(Buffer,addr+BLOCKSIZE*i, BLOCKSIZE,1) != SD_OK)
              pc.printf("Errore i= %d",i);
        x0+=incx;
        y0+=incy;
        if(y0>=y){
        x0++;
        y0-=y;
        }
              
    }
        
    //pc.printf("ok, serializato!\r\n");
  

    
}
unsigned int  N_bk = 120;

void leggi_img(int x_0,int y_0,uint64_t addr){
    int x,y;
    uint32_t Buffer[N_bk*BLOCKSIZE+1];
    int n_b=0;
    if(sd.ReadBlocks(Buffer, addr, BLOCKSIZE,1)== SD_OK){
       // pc.printf("SD READ : OK.\r\n");

        n_b=Buffer[0];
        x=Buffer[2];
        y=Buffer[3];
   //  pc.printf("nb= %d\r\n",n_b);
    //  pc.printf("x =  %d - y= %d\r\n",x,y);
    }
    if(n_b<N_bk)N_bk=n_b;
    stampa_B(&Buffer[4],124,x,y,0,0,x_0,y_0);
    int incx,incy;
    incx=N_bk*128/y;
    incy=(N_bk*128)%y;
    int x0,y0;
    x0=124/y;
    y0=124%y;
    

   // pc.printf("x= %d, y= %d, x0= %d, yo= %d, y_00= %d\r\n",x,y,x0,y0,y_0);
    for(int i=1;i<n_b;i+=N_bk)
    
        if(sd.ReadBlocks(Buffer, addr+BLOCKSIZE*i, BLOCKSIZE,N_bk)== SD_OK){
       // pc.printf("SD READ %d: OK.\r\n",i);
        stampa_B(Buffer,128*N_bk,x,y,x0,y0,x_0,y_0);
        x0+=incx;
        y0+=incy;
        if(y0>=y){
        x0++;
        y0-=y;
        }
   
    }
   
    
 //   pc.printf("finito !");

}


void riemp_B(uint32_t b[],int n,int x0,int y0,int x,int y){
 
   // pc.printf("ok\r\n");
}

void stampa_B(uint32_t b[],int n,int x,int y,int x0,int y0,int x_0,int y_0){
   int cont=0;
   int y1=y0;
   int j;
   
  for(int i=x0;i<x;i++)
        for(j=y1;j<y;j++){
             y1=0;
             lcd.DrawPixel(j+x_0,x-i+y_0,b[(i-x0)*y+j-y0]);
            //cont++;
        if(++cont==n)return;
    } 
}

void scrivi_dato(uint32_t Buffer[],uint64_t addr,int n=1){
    //pc.baud(921600);
if(addr>=start_addr_dato){
     if(sd.WriteBlocks(Buffer,addr, BLOCKSIZE*n,1) != SD_OK){
              pc.printf("\t\t\t\t ->  Errore scrittura : ");
              pc.printf("addres = %x \r\n",addr);
              }
    else 
        { 
        //  pc.printf("non salvato:\t%s\r\n",(char*)Buffer);
               // pc.printf("addres = %x ",addr);

        //slave.address(0xA0);
         
         }
 }
 else pc.printf("errore indirizzo non valido, addr= %d -- addr_Base = %d\r\n",addr,start_addr_dato);       
}

void printa_dato(uint32_t Buffer[],uint64_t addr){
if(addr>=start_addr_dato)
     if(sd.ReadBlocks(Buffer,addr, BLOCKSIZE,1) != SD_OK)
                pc.printf("errore lettura");
    else    pc.printf("Dato letto: %s",(char*)Buffer);
}

void scrivi_dato_progresione(uint32_t Buffer[]){
   /*
   uint32_t B[512];
   sd.ReadBlocks((uint32_t*)B,0, BLOCKSIZE,1);
   B[10]++;
   sd.WriteBlocks((uint32_t*)B,0, BLOCKSIZE,1);
   
   scrivi_dato(Buffer,512*B[10]);
   */
   static int u=0;
   
   static int n=-1;
   const int k=32;
   static uint32_t Dato_B[BLOCKSIZE*k];
   static int B[BLOCKSIZE];
   uint64_t addr;
   //pc.printf("n=%d",n);
    if(n<0){pc.printf("inizio scritura\r\n");sd.ReadBlocks((uint32_t*)B,0, BLOCKSIZE,1);n=0;
        if(B[10]<start_addr_dato/512)pc.printf("problemone, l' indirizzo salvato non è valido!\r\n");
        }
    //pc.printf("inizio scritura");
    
    if(n==k-1){
    
    //sd.ReadBlocks((uint32_t*)B,0, BLOCKSIZE,1);
    sd.ReadBlocks((uint32_t*)B,0, BLOCKSIZE,1);
    strcpy((char*)Dato_B[BLOCKSIZE*n],(char*)Buffer);
    addr=B[10];
    addr=BLOCKSIZE*addr;
     
    scrivi_dato(Dato_B,addr,k);
    
    u++;
    //if(u==640||u==800||u==2240||u==2976||u==2720)B[10]=B[10]+2*k;else
     B[10]=B[10]+k;
    
    sd.WriteBlocks((uint32_t*)B,0, BLOCKSIZE,1);
    
    n=0;
   }
   else {strcpy((char*)Dato_B[BLOCKSIZE*n],(char*)Buffer);n++;}
   
   
  
}

void printa_dato_progressione(){
    
    pc.printf("\r\n Sto per legere in progresione ... ");
    uint32_t B[BLOCKSIZE];
    sd.ReadBlocks((uint32_t*)B,0, BLOCKSIZE,1);
    int n=B[10];
    pc.printf("n=%d\r\n",n-start_addr_dato/512);
    for(int i=start_addr_dato;i<n*BLOCKSIZE;i+=BLOCKSIZE)
    printa_dato((uint32_t*)B,i);
    
    pc.printf("\tfine\r\n"); 
}

void cancella_dati(){
    
 int  B[512];
        pc.printf("\n dati cancellati \n");
        B[10]=start_addr_dato/512;
        sd.WriteBlocks((uint32_t*)B,0, BLOCKSIZE,1);    
}

#endif