#include "mbed.h"
#include "header.h"
#include <time.h>
#include "MPU6050.h"

int main(){
    i2c.frequency(400000);
    MPU6050 mpu6050;
    uint8_t whoami = mpu6050.readByte(MPU6050_ADDRESS, WHO_AM_I_MPU6050);  // Read WHO_AM_I register for MPU-6050
  
    if (whoami == 0x68){  

     
        mpu6050.MPU6050SelfTest(SelfTest); // Start by performing self test and reporting values
    
        if(SelfTest[0] < 1.0f && SelfTest[1] < 1.0f && SelfTest[2] < 1.0f && SelfTest[3] < 1.0f && SelfTest[4] < 1.0f && SelfTest[5] < 1.0f){
            mpu6050.resetMPU6050(); // Reset registers to default in preparation for device calibration
            mpu6050.calibrateMPU6050(gyroBias, accelBias); // Calibrate gyro and accelerometers, load biases in bias registers  
            mpu6050.initMPU6050(); pc.printf("MPU6050 initialized for active data mode....\n\r"); // Initialize device for active mode read of acclerometer, gyroscope, and temperature
        }
        else
            pc.printf("Device did not the pass self-test!\n\r");
    }
    else{
    pc.printf("Could not connect to MPU6050: \n\r");
    pc.printf("%#x \n",  whoami);
 
    while(1) ; // Loop forever if communication doesn't happen
    }
    
    int i;
    for(i = 0; i < BLOCCO; i++){
        
            vettore[i].x = 0;
            vettore[i].y = 0;
            vettore[i].z = 0;
            vettore[i].xx = 0;
            vettore[i].yy = 0;
            vettore[i].zz = 0;
     
    }
    
   while (true) {
    // Read the WHO_AM_I register, this is a good test of communication
    srand(time(NULL));
    int i;
    static const int off_set_a=400;
    for(i = 0; i < BLOCCO; i++){
       
        // If data ready bit set, all data registers have new data
        if(mpu6050.readByte(MPU6050_ADDRESS, INT_STATUS) & 0x01) {  // check if data ready interrupt
                mpu6050.readAccelData(accelCount);  // Read the x/y/z adc values
                mpu6050.getAres();
    
                //Now we'll calculate the accleration value into actual g's
                vettore[i].x = (float)accelCount[0]*aRes;  // get actual g value, this depends on scale being set
                vettore[i].y = (float)accelCount[1]*aRes;   
                vettore[i].z = (float)accelCount[2]*aRes;  
            
                mpu6050.readGyroData(gyroCount);  // Read the x/y/z adc values
                mpu6050.getGres();
 
                //Calculate the gyro value into actual degrees per second
                vettore[i].xx = (float)gyroCount[0]*gRes;  // get actual gyro value, this depends on scale being set
                vettore[i].yy = (float)gyroCount[1]*gRes;  
                vettore[i].zz = (float)gyroCount[2]*gRes;  
                             
            }  
   
            pc.printf("%03.0f %03.0f %03.0f %03.0f %03.0f %03.0f\n\r",100*vettore[i].x+off_set_a,100*vettore[i].y+off_set_a,100*vettore[i].z+off_set_a,100*vettore[i].xx+off_set_a,100*vettore[i].yy+off_set_a,100*vettore[i].zz+off_set_a);
         
        }      
    }
}
