// UNINA CORSE programma dashboard 2018
// LED rpm e marcia sette segmenti (a logica negativa)

#include "mbed.h"

#define rpm_scale 0.39063
#define RPMADD 0x40
#define GEARADD 0x42

#define OFF 0b11111111

#define LED1   0b11111110
#define LED2   0b11111101
#define LED3   0b11111011
#define LED4   0b11110111
#define LED5   0b01111111
#define LED6   0b10111111
#define LED7   0b11011111
#define LED8   0b11101111

#define SOGLIA0 0
#define SOGLIA1 3000
#define SOGLIA2 4250
#define SOGLIA3 5500
#define SOGLIA4 6750
#define SOGLIA5 8000
#define SOGLIA6 9250
#define SOGLIA7 10500

#define CIFRA0 0b10000100
#define CIFRA1 0b11110101
#define CIFRA2 0b10100010
#define CIFRA3 0b11100000
#define CIFRA4 0b11010001
#define CIFRA5 0b11001000
#define CIFRA6 0b10001000
#define CIFRA7 0b11100101
#define CIFRA8 0b10000000
#define CIFRA9 0b11000000
#define CIFRAn 0b10111001
#define CIFRAe 0b10001010

void acquisisci(CANMessage msg);
void outputGear(int gear);
void outputRpm(int rpm);

CAN can(D10,D2);    //rd, td
I2C i2c(D4, D5);    //sda, scl
Serial pc(USBTX, USBRX);
DigitalOut resetCAN(D7);
char cmd[1];
int rpm=0, gear=0; // giri motore e marcia

int main() {
    CANMessage msg;
    pc.printf("inizio\n\r");

    wait_ms(500);
    resetCAN=1;
    wait_ms(500);
    resetCAN=0;
    wait_ms(100);

    pc.printf("can riavviato\n\r");
    can.frequency(500000);

    
    while(1) {
        acquisisci(msg);
        outputGear(gear);
        outputRpm(rpm);
        wait_ms(50);    
    }
}


void acquisisci(CANMessage msg){
    if(can.read(msg)){
        switch (msg.id){
            case(0x1f0a000):
                unsigned int rpm_msb=msg.data[0]; //primo byte dei giri motore
                unsigned int rpm_lsb=msg.data[1];
                rpm = (rpm_msb+rpm_lsb<<8)*rpm_scale;
                pc.printf("GIRI= %d\n\r",rpm);
                break;
            case(0x1f0a003):
                gear=msg.data[3];
                pc.printf("M= %d \n\r",gear);
                break;
        }
    }
}

void outputGear(int gear){
    pc.printf("output gear= %d\n\r",gear);

    switch(gear){
        case 0:
            cmd[0] = CIFRAn;
            break;
        case 1:
            cmd[0] = CIFRA1;
            break;
        case 2:
            cmd[0] = CIFRA2;
            break;
        case 3:
            cmd[0] = CIFRA3;
            break;
        case 4:
            cmd[0] = CIFRA4;
            break;
        case 5:
            cmd[0] = CIFRA5;
            break;
        case 6:
            cmd[0] = CIFRA6;
            break;
        /*case 7:
            cmd[0] = CIFRA7;
            break;
        case 8:
            cmd[0] = CIFRA8;
            break;        
        case 9:
            cmd[0] = CIFRA9;
            break; */
        default:
            cmd[0] = CIFRAe;
            break;
        }
        
        i2c.write(GEARADD,cmd,1);
}


void outputRpm(int rpm){
    pc.printf("output rpm= %d\n\r",rpm);

    if(rpm<SOGLIA0) cmd[0] = OFF;
    else if(rpm<SOGLIA1) cmd[0] = LED1;
    else if(rpm<SOGLIA2) cmd[0] = LED1 & LED2;
    else if(rpm<SOGLIA3) cmd[0] = LED1 & LED2 & LED3;
    else if(rpm<SOGLIA4) cmd[0] = LED1 & LED2 & LED3 & LED4;
    else if(rpm<SOGLIA5) cmd[0] = LED1 & LED2 & LED3 & LED4 & LED5;
    else if(rpm<SOGLIA6) cmd[0] = LED1 & LED2 & LED3 & LED4 & LED5 & LED6;
    else if(rpm<SOGLIA7) cmd[0] = LED1 & LED2 & LED3 & LED4 & LED5 & LED6 & LED7;
    else if(rpm>=SOGLIA7) cmd[0] = LED1 & LED2 & LED3 & LED4 & LED5 & LED6 & LED7 & LED8;
    
    i2c.write(RPMADD,cmd,1);
}

