 
#include <stdint.h>
#include "mbed.h"
#include <ros.h>
#include <std_msgs/Empty.h>
#include <std_msgs/Int32MultiArray.h>
#include <BNO055.h>
#include <initializations.h>
#include <definitions.h>
#include <prototypes.h>
#include <Mx28.h>

bool startFlag = 0;

void runLift(void){
    stallCheck();
    //Check If Arrived
    if (abs(control.height - currentPosition) < 6){ 
        liftSpeed.write(0);
        stopHallInt();
        startFlag = 0;
    }
    else {

        if(startFlag == 0){
            startHallInt();
            startFlag = 1;
        }   
        // Set direction
        if(control.height > currentPosition){
            liftDirection.write(LIFTUP);   
        }
        else if(control.height < currentPosition){
            liftDirection.write(LIFTDOWN);
        }         
       // liftSpeed.write(liftDutyCycle);
       liftSpeed.write(0.4);
    }  
}

//Determining if the lift stalled and stopping if it is
void stallCheck(void){
    if(stallcount > 3 && liftSpeed.read() > 0 && eStopFlag == 0){
        liftSpeed.write(0);
        if (liftDirection.read() == LIFTUP){
            currentPosition = LIFTHEIGHTMAX;
            control.height = LIFTHEIGHTMAX;
        }else{
            currentPosition = 0;
            control.height = 0;
        }
    } 
}