#include "mbed.h"
#include <definitions.h>

//Stall Checking Interrupt
void hallInterrupt(){
    if(prevPosition == currentPosition){
        stallcount++;
    }
    else if(liftSpeed.read() > 0){
        prevPosition = currentPosition;
        stallcount = 0;          
    }
}

//E-Stop Interrupt
void eStopOn(){
    eStopFlag = 1;
    hallInt.detach();
}
void eStopOff(){
    eStopFlag = 0;
    hallInt.attach(&hallInterrupt, 0.03);
}

//External Interrupt Counter
class Hall_Counter_1 {
public:
    Hall_Counter_1(PinName pin) : _interrupt(pin) {        // create the InterruptIn on the pin specified to Counter
        _interrupt.rise(this, &Hall_Counter_1::increment); // attach increment function of this counter instance
    }
    void increment() {
        if(filter_hall1.read_ms() > 5){
            if(liftDirection.read() == LIFTUP){
                currentPosition++;
            }
            else{
                currentPosition--;
            }
            filter_hall1.reset();
        }
    }
 
private:
    InterruptIn _interrupt;
};

Hall_Counter_1 hall_Counter_1(PC_7);