#ifndef __DEFINITIONS_H__
#define __DEFINITIONS_H__

#include "mbed.h"
#include <BNO055.h>
#include <Mx28.h>

// Generic definitions
#define     TRUE            1
#define     FALSE           0

// ROS definitions
#define     ROSROLL         0  
#define     ROSPITCH        1
#define     ROSYAW          2
#define     ROSHEIGHT       3
#define     ROSMODE         4
#define     ROSYAWSP        5  
#define     ROSROLLSP       6 
#define     ROSPITCHSP      7 
#define     ROSHEIGHTSP     8 
#define     ROSDATALENGTH   9

// Gimbal definitions
#define     YAWID           1
#define     PITCHID         2
#define     ROLLID          3
#define     YAWZERO         2015
#define     PITCHZERO       2350
#define     ROLLZERO        2302
#define     YAWMIN          0       // -177 degrees.
#define     YAWMAX          4063    // +177 degrees.
#define     PITCHMIN        1326    // -90 degrees.
#define     PITCHMAX        3000    // +90 degrees is at 3374
#define     ROLLMIN         2100    // -90 degrees is at 1278
#define     ROLLMAX         2500   // +90 degrees is at 3374 
#define     SERVOSPEEDMIN   1      // Min speed for gimbal servos
#define     SERVOSPEEDMAX   200    // Max speed for gimbal servos
#define     DYNASCALE       11     // Should be 11.4, but int is currently being used

// Lift definitions
#define     LIFTUP          1
#define     LIFTDOWN        0
#define     LIFTHEIGHTMAX   3000 // 119.6 cm should be 3000
#define     LIFTHEIGHTMIN   5 //51.6 cm
// Delta Height for Lift is 68cm

// Classes
struct fields{
volatile int        yaw;
int                 yawSpeed;
volatile int        pitch;
int                 pitchSpeed;
volatile int        roll;
int                 rollSpeed;
volatile  int       height;
volatile  int       heightSpeed;
bool                stabilize;
bool                masterOn;
bool                liftRun;
bool                gimbalRun;
bool                shutdown;
bool                initialize;
volatile int        mode;
};

extern struct           fields          control;
extern struct           fields          rosInput;
extern volatile int     currentPosition;
extern float            liftDutyCycle; 
extern int              prevPosition;
extern bool             stall;
extern bool             rosFlag;
extern bool             eStopFlag;
extern int              stallcount;
extern const int        addr;
extern Ticker           hallInt;
extern Timer            filter_hall1;
extern Timer            rosMode_Delay;
extern PwmOut           liftSpeed;
extern DigitalOut       liftDirection;
extern DynamixelClass   gimbal;
extern DigitalOut       value0;
extern DigitalOut       value1;
extern InterruptIn      eStop;

#endif