 /*
 * Code for the Module Microcontroller as part of the 
 * Autonomous Camera Kart project.
 * Controls the Gimbal motors, raise and lower mechanism,
 * IMU sensor input, communication with the NUC onboard computer.
 */

// Library Includes
#include <stdint.h>
#include "mbed.h"
#include <ros.h>
#include <std_msgs/Empty.h>
#include <std_msgs/Int32MultiArray.h>
#include <BNO055.h>
#include <initializations.h>
#include <definitions.h>
#include <prototypes.h>
#include <Mx28.h>

// Micro Module Declarations
PwmOut              liftSpeed(D10); // Normally D10
DigitalOut          liftDirection(D11);
DigitalIn           button(USER_BUTTON);
Ticker              hallInt;
Timer               filter_hall1;
Timer               rosMode_Delay;
DynamixelClass      gimbal(57600, D7, D8, D2);
InterruptIn         eStop(D5);

ros::NodeHandle     nh;
ros::Subscriber<std_msgs::Int32MultiArray> sub("module_command", &module_commandCB);

// Global Variable
struct          fields control;
struct          fields rosInput;
float           liftDutyCycle = 0;
volatile int    currentPosition = 0;
int             prevPosition = 0;
int             stallcount = 0;
bool            rosFlag = 1;
bool            eStopFlag = 0;

// Main Program
int main() {
    // Initializations
    filter_hall1.start();                       //Start Filtering Timer
    eStop.fall(&eStopOn);
    eStop.rise(&eStopOff);   
    setupGimbal();                              // Gimbal
    setupLift();                                // Lift
    setupROSNode(nh, sub);                     // ROS Node Handle
    rosInput.mode = 0;

    // Main Loop
    while (1) { 
    //ROS Functions 
        nh.spinOnce();
        rosCheck();    
    // Lift Operation
        runLift();
    //Run Gimbal 
        runGimbal();
    }     
}
