#ifndef _ROS_stm32_game_manager_game_status_h
#define _ROS_stm32_game_manager_game_status_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"


namespace game_manager_node
{

  class game_status_msg : public ros::Msg
  {
    public:
        typedef uint8_t _game_status_type;
        _game_status_type game_status;
        typedef uint8_t _init_status_type;
        _init_status_type init_status;

        game_status_msg():
            game_status(0),
            init_status(0)
        {
        }
    
        virtual int serialize(unsigned char *outbuffer) const
        {
            int offset = 0;
            *(outbuffer + offset + 0) = (this->game_status >> (8 * 0)) & 0xFF;
            offset += sizeof(this->game_status);
            *(outbuffer + offset + 0) = (this->init_status >> (8 * 0)) & 0xFF;
            offset += sizeof(this->init_status);
            return offset;
        }
    
        virtual int deserialize(unsigned char *inbuffer)
        {
            int offset = 0;
            this->game_status =  ((uint8_t) (*(inbuffer + offset)));
            offset += sizeof(this->game_status);
            this->init_status =  ((uint8_t) (*(inbuffer + offset)));
            offset += sizeof(this->init_status);
            return offset;
        }
    
        const char * getType(){ return "game_manager/GameStatus"; };
        const char * getMD5(){ return "702f6698fa11258022a15f6736fecb8c"; };

  };

}
 

#endif