#ifndef _ROS_stm32_gobeur_Gobeur_h
#define _ROS_stm32_gobeur_Gobeur_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include <Servo.h>
#include "../actuators.h"
#include "ros/msg.h"



#define GOBEUR_SUCKING_TIMEOUT 1
#define GOBEUR_CLOSING_TIMEOUT 1
#define GOBEUR_OPENING_TIMEOUT 1
#define GOBEUR_PAUSE_TIMEOUT 1



namespace stm32_actuators_node
{

  class Gobeur_msg : public ros::Msg
  {
    public:
        typedef uint8_t _index_gobeur_type;
        _index_gobeur_type index_gobeur;
        typedef uint8_t _gobeur_order_type;
        _gobeur_order_type gobeur_order;

        Gobeur_msg():
            index_gobeur(0),
            gobeur_order(0)
        {
        }
    
        virtual int serialize(unsigned char *outbuffer) const
        {
            int offset = 0;
            *(outbuffer + offset + 0) = (this->index_gobeur >> (8 * 0)) & 0xFF;
            offset += sizeof(this->index_gobeur);
            *(outbuffer + offset + 0) = (this->gobeur_order >> (8 * 0)) & 0xFF;
            offset += sizeof(this->gobeur_order);
            return offset;
        }
    
        virtual int deserialize(unsigned char *inbuffer)
        {
            int offset = 0;
            this->index_gobeur =  ((uint8_t) (*(inbuffer + offset)));
            offset += sizeof(this->index_gobeur);
            this->gobeur_order =  ((uint8_t) (*(inbuffer + offset)));
            offset += sizeof(this->gobeur_order);
            return offset;
        }
    
        const char * getType(){ return "stm32_actuators/Gobeur_msg"; };
        const char * getMD5(){ return "02fe53940b821cdd54efe4bd91e2b68b"; };

  };

}


void gobeur_trait_msg(const stm32_actuators_node::Gobeur_msg& gobeur_msg);



class Gobeur
{
    public:
    
        typedef enum
        {released, sucking, closing, ack_sucked, sucked, releasing, ack_released}
        state_gobeur_t;
        
        typedef enum
        {suck, release}
        gobeur_order_t;

        Gobeur(PinName pin_turbine, PinName pin_servo, float turbine_on, float turbine_off, float servo_open, float servo_close);
        
        void update_order(int order);
        void automate(void);
        
        gobeur_order_t _order;
        state_gobeur_t _state;
        Servo* _turbine;
        Servo* _servo;
        
        float _turbine_on;
        float _turbine_off;
        float _servo_open;
        float _servo_close;
        
        
        
        float _time;
};
#endif
