#ifndef MADPULSE_H
#define MADPULSE_H
#include "utilityFunctions.h"
#include "mbed.h"
#include "ServoIn.h"
#include "ServoOut.h"
#include "BNO055.h"
#include "mavlink.h"

static DigitalOut imu_LED(LED1);
static DigitalOut wheel_LED(LED2);
static DigitalOut dwm_LED(LED3);
static DigitalOut auto_LED(LED4);
static DigitalOut auto_mode(p26);


typedef struct vector3{
    float x,y,z;
    }vector3;
    
    
class MadPulse {
        
    public:
    MadPulse(uint8_t id,Serial *port, BNO055 *imu, ServoIn *CH1,ServoIn *CH2, InterruptIn *irq, ServoOut *Steer, ServoOut *Throttle);
    
    uint8_t id;
    vector3 pos;
    vector3 vel;
    vector3 accel;
    vector3 gyro;
    vector3 mag;    
    angles euler;
    int counts;
    bool auto_flag;
    
    void getRCIn();
    void getAccel();
    void getGyro();
    void getMag();
    void getEuler();
    void getSpeed();
    void getPos();
    int getCounts(){return counts;}
    float getFreq(){return wheel_freq;}    
    void resetEnc();
    uint8_t sendMessage(Serial *obj,char* msg,uint8_t len);    
    
    void setSteer(float ang);
    void setThrottle(float thr);
    float wheel_freq,wheel_freq_old;
    ServoIn *_CH1;
    ServoIn *_CH2;
    
    private:
    PinName _sdaPin, _sclPin, _ch1Pin, _ch2Pin,_encPin, _strPin, _thrPin;
    BNO055 *_imu;
    Serial *_port;

    InterruptIn *_wheel_irq;
    ServoOut *_Steer;
    ServoOut *_Throttle;
    Ticker *_ticker;         //pointer to ticker object
    char buf[64];
    
    mavlink_local_position_ned_t pose;
    
    void sampleData();
    void wheelCallback();
    void rxCallback();
    int parseMessage(char  * msg);
    void sendDWMessage(uint8_t* msg,uint16_t len);
    bool rc_conn;
    float t_ws,dt_ws,dt,dt_old;
    float wheel_spd;
    Timer ti;
    };
    
    #endif