#include "mbed.h"
#include "mbedWSEsbc.h"

#define PI 3.14159
#define LOG_FREQ 100.0
#define CTRL_FREQ 100.0


DigitalOut myled(LED1);
float tstop = 180;   //initialize stop time
float dc = 0;      //initialize dc variable
float dt = 1/CTRL_FREQ; // set control loop sample time
float enc;
float ang;


int main()
{
    float log_timer = 0;  //initialize variable for log timer
    bool run_flag = false;
    bool run_ctrl = false;

    mbedWSEsbcInit(9600);  //Initialize the mbed WSE Project SBC
    wait(.2);   //delay at beginning for voltage settle purposes
    t.start();  // Set up timer

    pc.printf("Quanser DC Motor Control Data Aquisition Program\r\n");

    t.reset(); // zero timer
    float sampT = t.read();


    while(1) {

        if(pc.readable()) {
            char c = pc.getc();
            if(c == 'H' || c == 'h') {
                pc.printf("Command List...\r\n");
                pc.printf("c - run closed loop controller\r\n");
                pc.printf("o - run open loop control\r\n");
                pc.printf("h - display this prompt and exit\r\n");            
                pc.printf("Enter Command\r\n");

            }
            if(c == 'C' || c == 'c') {
                
                pc.printf("Enter test duration in seconds...\r\n");
                pc.scanf("%f",&tstop);
                pc.printf("Test duration set to %.1f seconds.\r\n",tstop);
                
                pc.printf("Running Closed Loop Control for %.1f seconds, press any key to stop test...\r\n",tstop);
                run_flag = true;
                run_ctrl = true;
            }

            if(c == 'O' || c == 'o') {

                pc.printf("Enter desired duty cycle for test as a decimal between 0.00-1.00 \r\n",tstop);
                pc.scanf("%f",&dc);
                pc.printf("Duty Cycle is set to %.2f \r\n",dc);

                pc.printf("Enter test duration in seconds...\r\n");
                pc.scanf("%f",&tstop);
                pc.printf("Test duration set to %.1f seconds.\r\n",tstop);

                pc.printf("Running test for %.1f seconds, press any key to stop test...\r\n",tstop);
                run_flag = true;
                run_ctrl = false;
            }

            if(run_flag) {

                wait(1);
                t.reset();
                //Pendulum Posiiton when code starts will be the reference position
                LS7366_write_DTR(2,0);    //zero encoder channel 2    
                LS7366_reset_counter(2);  
                log_timer = 0;
                while(t.read() < tstop) {

                    //Emergency Stop check
                    if(pc.readable()) { //if any key is hit turn of motor and break while loop
                        mot_control(1, 0.0);
                        break;
                    }

                    // Read encoder
                    float enc = (float)LS7366_read_counter(2);
                    
                    // Convert from counts to radians
                    ang = 2*PI*enc/4096;
                    
                    // Estimate States


                    if(run_ctrl) { //If controller is active
                      
                        // Control Law Goes Here
                                                                        

                    }else{ // if open loop test                       
                        
                    }
                    
                    
                    // Saturate dc command to send no more than maximum value
                    if(dc>1.0) {
                        dc =1.0;
                    }
                    if(dc<-1.0) {
                        dc = -1.0;
                    }

                    //Set the new output.

                    mot_control(1, -dc); // negative value required due to polarity of motor


                    if( (t.read()- log_timer) >= (1.0/LOG_FREQ)) { //If log sample time has passed since last write
                        pc.printf("%.3f, %.3f, %.3f\r\n", t.read(),ang,dc); //write data to scren
                        log_timer = t.read();
                    }


                    led3=!led3;  //Flash Led to Indicate program is running
                    wait(dt);   //Wait for sample time of loop frequency
                }  // while t < tstop
                mot_control(1, 0.0); // Turn off Pump once test is finished
                run_flag = false;
                run_ctrl = false;
                pc.printf("\r\nEnter Command\r\n");
            } //if run flag
        } // if pc.readable
    }//while
}//main
