#include "mbed.h"
#include "mbedWSEsbc.h"

#define PI 3.14159
#define LOG_FREQ 2.0
#define CTRL_FREQ 200.0
#define STOP 0
#define IDLE 1
#define RUN 2

DigitalOut myled(LED1);

int main()
{
    float log_timer = 0;  //initialize variable for log timer
    bool run_flag = false;
    bool run_ctrl = false;

    mbedWSEsbcInit(9600);  //Initialize the mbed WSE Project SBC
    wait(.2);   //delay at beginning for voltage settle purposes
    t.start();  // Set up timer

    pc.printf("Quanser Twin Tank Control Data Aquisition Program\r\n");

    t.reset(); // zero timer
    float sampT = t.read();
    float tstop = 600;   //initialize stop time
    float dc = 0;      //initialize dc variable
    float q = 0;
    float q0 = 20;
    float dt = 1/CTRL_FREQ; // set control loop sample time
    float h1 = 0;
    float h2 = 0;
    float freq = 1;
    float T = 10;
    float amp = 5;
    bool freq_resp = false;

    bool use_int = false;
    int run_state = 0;

    while(1) {

        if(pc.readable()) {
            char c = pc.getc();

            if(c == 'H' || c == 'h') {
                pc.printf("Command List...\r\n");
             //   pc.printf("a - set Amplitude\r\n");
                pc.printf("f - Run Frequency Resonse\r\n");
                pc.printf("t - Run Time Response\r\n");                
                pc.printf("i - Return to Operating Point\r\n");
               // pc.printf("o - Set Operating Point flow\r\n");
                pc.printf("r - Run Test\r\n");
                pc.printf("s - Stop Test\r\n");
                pc.printf("h - display this prompt and exit\r\n");
                pc.printf("Enter Command\r\n");

            }

          /*  if(c == 'A' || c == 'a') {

                pc.printf("Enter the Amplitude of dQ in (cm^/s)...\r\n");
                pc.scanf("%f",&amp);
                pc.printf("Amplitude of delta flow set to %.1f (cm^3/s).\r\n",amp);

            }*/

            if(c == 'F' || c == 'f') {

                pc.printf("Enter the Period of Oscillation in (s)...\r\n");
                pc.scanf("%f",&T);
                pc.printf("Period of oscillation set to %.1f seconds.\r\n",T);
                pc.printf("Test Set to Frequency Response, Press R to begin...\r\n",tstop);
                
                freq_resp = true;
            }
           /* if(c == 'O' || c == 'o') {

                pc.printf("Enter the Operating Flow Rate Q0 in (cm^/s)...\r\n");
                pc.scanf("%f",&q0);

            }*/
            if(c == 'T' || c == 't') {

                pc.printf("Test Set to Time Response, Press R to begin...\r\n",tstop);
                freq_resp = false;                

            }
            if(c == 'I' || c =='i') {
                run_state = IDLE;
                t.reset();
                log_timer = 0;
                pc.printf("Running Returning to OP \r\n");

            }
            if(c == 'R' || c == 'r') {

                if(freq_resp) {
                    pc.printf("Running Test Frequency Response for %.1f seconds...\r\n",tstop);
                } else {
                    pc.printf("Running Test Step Response for %.1f seconds...\r\n",tstop);
                }
                run_state = RUN;
                t.reset();
                log_timer = 0;

            }
            if(c == 'S' || c == 's') {
                pc.printf("Test Complete, Returning to OP\r\n");
                run_state = STOP;
               // t.reset();
            }
        } // if pc.readable

        // read analog to digital chip for presssure sensors
        float tank2 = read_max1270_volts(0, 1, 1);   //chan, range, bipol
        float tank1 = read_max1270_volts(1, 1, 1);

        //Logic to exit loop if tank gets too full
        if(tank1 > 4.1 || tank2 > 4.1) {
            run_state = STOP;
            t.reset();
           // break;
        }

        //Convert Voltage to Height
        h1 = 6.4*tank1;
        h2 = 6.4*tank2;



        switch(run_state) {
            case STOP: {
                mot_control(1, 0.0);
                break;
            }
            case IDLE: {
                
                q = q0;
                dc = 0.0076*q + 0.55;
                if( (t.read()- log_timer) >= (1.0/LOG_FREQ)) { //If log sample time has passed since last write
                    pc.printf("%.2f, %.3f, %.3f, %.3f\r", t.read(),h1,h2,q); //write data to scren
                    log_timer = t.read();
                }                
                mot_control(1, -dc);
                break;

            }
            case RUN: {
                
                if(t.read() > tstop) {
                    run_state= IDLE;
                }
                if(freq_resp) {

                    q = q0 + amp*sin((2*3.14159/T)*t.read());
                    dc =  0.0076*q + 0.55;
                } else {
                    q = q0 + amp;
                    dc =  0.0076*q + 0.55;
                }
                // Saturate dc command to send no more than maximum value
                if(dc>1.0) {
                    dc =1.0;
                }
                if(dc<-1.0) {
                    dc = -1.0;
                }

                if( (t.read()- log_timer) >= (1.0/LOG_FREQ)) { //If log sample time has passed since last write
                    pc.printf("%.2f, %.3f, %.3f, %.3f\r\n", t.read(),h1,h2,q); //write data to scren
                    log_timer = t.read();
                }

                mot_control(1, -dc); // negative value required due to polarity of pump motor
                break;

            }
            default: {
                mot_control(1, 0.0);
                break;
            }

        }

        led3=!led3;  //Flash Led to Indicate program is running
        wait(dt);   //Wait for sample time of loop frequency

    }//while
}//main
