#include "mbed.h"
#include "mbedWSEsbc.h"

#define PI 3.14159
#define LOG_FREQ 1.0
#define CTRL_FREQ 10.0

float tstop,pwm,log_timer,log_start,loop_time;
float duty_cycle;
bool run_flag;
double dt;

bool readAndParse(Serial *port);
int main()
{
    run_flag = false;
    log_timer = 0;  //initialize variable for log timer
    log_start = 0;
    loop_time = 0;
    tstop = 120;
    pwm = 0.7;
    led1 = led2 = led3 = led4 = 0;
    dt = (1/CTRL_FREQ);
    mbedWSEsbcInit(115200);  //Initialize the mbed WSE Project SBC
    wait(.2);   //delay at beginning for voltage settle purposes
    t.start();  // Set up timer
    pc.printf("Quanser Twin Tank Control Data Aquisition Program\r\n");

    t.reset(); // zero timer

    while(1) {
        loop_time = t.read();
        readAndParse(&pc);
        //Emergency Stop check
        /*if(pc.readable()) { //if any key is hit turn of motor and break while loop
            mot_control(1, 0.0);
            break;
        }*/
        // read analog to digital chip for presssure sensors
        if(run_flag) {
            float tank2 = read_max1270_volts(0, 1, 1);   //chan, range, bipol
            float tank1 = read_max1270_volts(1, 1, 1);

            //Logic to exit loop if tank gets too full
            if(tank1 > 4.1 || tank2 > 4.1) {
                pc.printf("%.2f, %.3f, %.3f, %.3f\r\n", t.read() -log_start,tank1,tank2,pwm);
                run_flag = false;               
            }


            // Saturate PWM command to send no more than maximum value
            if(pwm>1.0) {
                pwm =1.0;
            }
            if(pwm<-1.0) {
                pwm = -1.0;
            }

            //Set the new output.
            mot_control(1, -pwm); // negative value required due to polarity of pump motor

            float log_dt = t.read()- log_timer;
            float time = t.read() -log_start;
            if( log_dt >= (1.0/LOG_FREQ)) { //If log sample time has passed since last write
                log_timer = t.read();
                pc.printf("%.2f,%.3f,%.3f,%.3f\r\n",time,tank1,tank2,pwm); //write data to screen
             //   xbee.printf("%.2f,%.3f,%.3f,%.3f\r\n",time,tank1,tank2,pwm); //write data to screen
                
            }

            led1 = !led1;
            led2 = !led2;
            led3 = !led3;
            led4 = !led4;
         //   float loop_dur = (t.read()-loop_time);
           // printf("Loop Time %f %f %f\r\n", t.read()-loop_time, dt, loop_dur);
            wait(dt);   //Wait for sample time of loop frequency

        } //if run flag
        else { // Slow flash LED When system is not  running
            led1 = !led1;
            led2 = !led2;
            led3 = !led3;
            led4 = !led4;
            mot_control(1, 0); // negative value required due to polarity of pump motor
            wait(0.5);
        }
    }//while
}//main

bool readAndParse(Serial *port)
{

    char msg[64];
    int i = 0;

    if(port->readable()) {
        char c = port->getc();
        if(c=='$') {
            msg[i] = c;
            i++;
            while(1) {
                msg[i] = port->getc();
                if(msg[i]=='\n' || msg[i]=='\r') {
                    break;
                }
                i++;
            }
        }
    }

    if(!strncmp(msg, "$RUN", 4)) {
        run_flag = true;
        log_timer = 0;
        log_start = t.read();
        return true;
    } else if(!strncmp(msg, "$STOP", 5)) {
        mot_control(1, 0.0); // Turn off Pump once test is finished
        run_flag = false;
        return true;

    } else if(!strncmp(msg, "$PWM", 4)) {
        sscanf(msg,"$PWM,%f\n",&pwm);
        return true;
    } else {
        return false;
    }

}

