//****************************************
//  ES305 Linear Control Systems
//  Lab 2 - Introduction to mbed microcontroller
//  Exercise 5 - Controlling servo position with PWM and variable potentiometer
//
//  Brian Connett, LCDR, USN
//  exercise and code derived from mbed.org
//  exercise and code derived from Curtis Shorr, Capt, USAF
//****************************************

/*********************************************************************************/
//SCY202 LAB 2 - Introduction to Cyber Attack
//Program Name: Motor Control
//Program Description: This program uses the mbed application board to control
// an RC motor, DC motor and peltier device.  With user interface via 2
// potentiometers and lcd screen.
// Created by Capt Curtis Shorr, USAF, Instructor USNA
// Libraries and Code derived from mbed.org online community
/*********************************************************************************/


#include "mbed.h"                  //include mbed library
#include "Servo.h"                 //include Servo library

AnalogIn pot1(p15);                //declare pot1
Serial pc(USBTX,USBRX);            //declare serial comms over USB;
Servo rc_motor(p21);               //delcare Servo Motor

int main()
{

    
    rc_motor.calibrate(0.0009, 90.0); /********************** Servo Motor Calibration **************************/
    
    
    float motpos;                 //declare servo position variable
    float rc_control;
    while(1) {

        /********************* Servo Motor Control ***********************/
        rc_control = pot1.read();//reads pot1 input
        rc_motor = rc_control;   //send actuation command to servo

        motpos = pot1.read();     //read pot2 input & set as servo position
        motpos *= 1800;           //180 degrees with three sig figs
        motpos = (float)((int)motpos);
        motpos /= 10;
        pc.printf("RC Position:%9.6f\r",rc_control*180);
    }
}