//****************************************
//  ES305 Linear Control Systems
//  Lab 2 - Introduction to mbed microcontroller
//  Exercise 4 - Pulse Width Modulation
//  Adjusts Pulse Width Modulation output to vary the brightness of an onboard LED.
//  Uses the keyboard to increase or decrease the the PWM
//
//  Brian Connett, LCDR, USN
//  exercise and code derived from mbed.org
//****************************************

#include "mbed.h"                           //mbed header file from mbed.org includes MOST APIs required to operate LPC

Serial pc(USBTX, USBRX);                    //Create a Serial port connected to USB
PwmOut pwm1(LED1);                          //Creates a pulse-width modulation digital output assigned to the variable pwm1 at LED 1
float duty_cycle=0.0;

int main()
{
    pc.baud(921600);                         //Set up serial port baud rate
    pc.printf("Control of LED dimmer by host terminal\n\r");
    pc.printf("Press 'u' = to increase duty cycle, 'd' to decrease duty cycle\n\r");
    while(1) {
        char c =pc.getc();                  //Using the getc public member function of SERIAL to retrieve key press
        wait(0.001);
        if ((c == 'u') && (duty_cycle < 1.0)) { //When 'u' key is pressed duty cycle increases up to 100%
            duty_cycle += 0.01;
            pwm1 = duty_cycle;
        }
        if((c=='d')&&(duty_cycle > 0.0)) { //When 'd' key is pressed duty cycle increases down to 0%
            duty_cycle -= 0.01;
            pwm1 = duty_cycle;
        }
        pc.printf("%c %1.3f \n \r",c,duty_cycle);
    }


}