//****************************************
//  ES305 Linear Control Systems
//  Lab 2 - Introduction to mbed microcontroller
//  Exercise 2 - Analog to Digital Conversion
//  Reads variable input through the ADC, and control LED illumination using BusOut binary
//
//  Brian Connett, LCDR, USN
//****************************************

#include "mbed.h"                                                                            //mbed header file from mbed.org includes MOST APIs required to operate LPC

Serial pc(USBTX, USBRX);                                                                     //Create a Serial port connected to USB
AnalogIn Ain(p18);                                                                           //Create an AnalogIn variable connected to Pin 18
BusOut myLEDs(LED1,LED2,LED3,LED4);                                                          //Create a digital bus out, used for setting the state of collection of pins(LED)
float ADCdata;

int main()
{
    pc.baud(921600);                                                                         //Set up serial port baud rate
    pc.printf("ADC Data Values... \n\r");
    while (1) {
        ADCdata=Ain;
        pc.printf("Analog Value: %f Voltage Value: %f \n\r",ADCdata,ADCdata*3.3);            //Print to TeraTerm via Serial TX
        wait (01.0);
        if (ADCdata >= 0.8)                                                                  //Conditional analysis that illuminates cooresponding LED
            myLEDs=1;                                                                        //when specific AnalogIn values are met
        if (ADCdata < 0.8 && ADCdata >0.6)
            myLEDs=3;
        if (ADCdata < 0.6 && ADCdata >0.4)
            myLEDs=7;
        if (ADCdata < 0.4 && ADCdata >0.2)
            myLEDs=15;
        if (ADCdata < 0.2)
            myLEDs=0;

    }
}