#include "mbed.h"
// APIs
Serial pc(USBTX, USBRX); // tx, rx for serial USB interface to pc
SPI spi_max1270(p5, p6, p7);
SPI spi(p5, p6, p7);
DigitalOut max1270_cs(p8);  //MAX1270 ADC CS
DigitalOut mot1_ph1(p21);
//DigitalOut mot1_ph2(p22);
PwmOut mot_en1(p23);

LocalFileSystem local("local"); // Create the local filesystem under the name "local"

int read_max1270(int chan, int range, int bipol){
    int cword=0x80;     //set the start bit
    
    spi_max1270.frequency(10000000);
    spi_max1270.format(8, 0);   // 8 data bits, CPOL0, and CPHA0 (datasheet Digital Interface)
        
    cword |= (chan << 4);   //shift channel
    cword |= (range << 3);
    cword |= (bipol << 2);
            
    max1270_cs = 0;
           
    spi_max1270.write(cword);
    wait_us(15);    //15us
    spi_max1270.format(12, 3);
    
    int result = spi_max1270.write(0);
    
    max1270_cs = 1;
    spi_max1270.format(8, 0);
    return result;
}

float read_max1270_volts(int chan, int range, int bipol){
    float rangevolts=0.0;
    float volts=0.0;
    int adc_res;

    //read the ADC converter
    adc_res = read_max1270(chan, range, bipol) & 0xFFF;
        
   //Determine the voltage range
   if(range)  //RNG bit 
     rangevolts=10.0;
   else
     rangevolts=5.0;
             
   //bi-polar input range
   if(bipol){ //BIP is set, input is +/-
     if(adc_res < 0x800){ //if result was positive
      volts = ((float)adc_res/0x7FF) * rangevolts;      
     }       
     else{  //result was negative
      volts = -(-((float)adc_res/0x7FF) * rangevolts) - (rangevolts * 2.0); 
     }
   }
   else{  //input is positive polarity only
      volts = ((float)adc_res/0xFFF) * rangevolts;   
   }
   
   return volts;     
}

float Tank1,Tank2,dt,h1,h2;
float Ts = 1.0; // Sampling period 1/Ts Hz

// Calibration constant: change for your system
float v10 = 0;// V
float v20 = 0; //V
float c1 = 1; // cm/V
float c2 = 1;// cm/V

int leng = 200;
// Arrays for data storage
float etime[200];
float t1v[200];
float t2v[200];
float t1h[200];
float t2h[200];
float dcp[200];
Timer t;

 // Open "results.M" on the local file system for writing
FILE *fp = fopen("/local/cal.M","w");

float cntr;
float dc;
int k;

int main ()
{
    pc.baud(921600); // Establish baud rate 
    mot_en1.period_us(50); // Set PWM length to 50 us   
    max1270_cs = 1; // Activate A/D
    cntr = 0.0; // cntr used to keep track of sample period and elpased time
    
    // initialize data vectors
    for(k=0;k<leng;k++)
  { etime[k] = 0.0;
    t1v[k] = 0.0;
    t2v[k] = 0.0;
    t1h[k] = 0.0;
    t2h[k] = 0.0;
    dcp[k] = 0.0;    
  }
  k = 0; // Reset index counter
    pc.printf(" Time Tank1  Tank2 H1    H2     DC \n\r");        
    while(cntr*Ts <= leng) {
        t.start(); // start measuring comp time
        
        // Read pressure sensors        
        Tank1 = read_max1270_volts(1, 1, 1);
        Tank2 = read_max1270_volts(0, 1, 1);
        
        // Convert pressure voltage to tank height
        h1 = c1*(Tank1 - v10);
        h2 = c2*(Tank2 - v20);
                
        // Drive pump for ID
        if (cntr*Ts <= 10) {
            dc = 0.0;
        } else if (cntr*Ts <= 200) {
            dc = -0.7;
        } else {
            dc = 0.0;
        } 
        //dc = -0.7;               
        
        if(dc > 0.0){
            //mot1_ph2 = 0;
            mot1_ph1 = 1;
            mot_en1 = dc;
        }
        else if(dc < -0.0){
            mot1_ph1 = 0;
            //mot1_ph2 = 1;
            mot_en1 = abs(dc);}
        // Log data
        etime[k] = cntr*Ts;
        t1v[k] = Tank1;
        t2v[k] = Tank2;
        t1h[k] = h1;
        t2h[k] = h2;
        dcp[k] = -dc;
        k++;
              
        t.stop(); // end measuring comp time
        dt = Ts-t.read();
        //pc.printf("%5.2f %5.2f %5.2f %5.2f \n\r",cntr*Ts,Tank1,Tank2,dc);
        pc.printf("%5.2f %5.2f %5.2f %5.2f %5.2f %5.2f \n\r",cntr*Ts,Tank1,Tank2,h1,h2,dc);        
        t.reset();
        cntr=cntr+1;
        wait(dt); // wait to ensure sampling period set by Ts    
    }//while
    //mot1_ph2 = 0;
    mot_en1 = 0.0;
    
    // Print out log variables in MATLAB structured variable format.
    pc.printf("Printing log variables to file on mBed           ... ");
    if(1) {
        for(k=0; k<200; k++) {
            fprintf(fp,"t(%d,1) = %.5f;\n",k+1,etime[k]);
            fprintf(fp,"t1v(%d,1) = %.5f;\n",k+1,t1v[k]);
            fprintf(fp,"t2v(%d,1)    = %.5f;\n",k+1,t2v[k]);
            fprintf(fp,"t1h(%d,1)    = %.5f;\n",k+1,t1h[k]);
            fprintf(fp,"t2h(%d,1)    = %.5f;\n",k+1,t2h[k]);
            fprintf(fp,"dcp(%d,1)    = %.5f;\n",k+1,dcp[k]);            
        }        
    }
    printf("done.\r\n");

    // Close file
    fclose(fp);
    
}//main