#include "mbed.h"
#define PI (3.14159)
//=============================================================================
// Four commands for the Instruction Register (B7,B6) - LS7366
//=============================================================================
#define CLR     0x00    //Clear Instruction
#define RD      0x01    //Read Instruction
#define WR      0x02    //Write Instruction
#define LOAD    0x03    //Load Instruction

//=============================================================================
// Register to Select from the Instruction Register (B5,B4,B3) - LS7366
//=============================================================================
#define NONE        0x00    //No Register Selected
#define MDR0        0x01    //Mode Register 0
#define MDR1        0x02    //Mode Register 1
#define DTR         0x03    //Data Transfer Register
#define CNTR        0x04    //Software Configurable Counter Register
#define OTR         0x05    //Output Transfer Register
#define STR         0x06    //Status Register
#define NONE_REG    0x07    //No Register Selected

SPI spi(p5, p6, p7);
DigitalOut LS7366_1_CS(p19);    //CS for LS7366
DigitalOut LS7366_2_CS(p20);    //CS for LS7366

//----- LS7366 Encoder/Counter Routines --------------------
void LS7366_cmd(int inst,  int reg)
{
    char cmd;

    cmd = (inst << 6) | (reg << 3);
    spi.write(cmd);
}

long LS7366_read_counter(int chan_num)
{
    union bytes {
        char byte_enc[4];
        long long_enc;
    } count;

    if(chan_num!=2) {
        LS7366_1_CS = 0;
        wait_us(1);
        LS7366_cmd(LOAD,OTR);//cmd = 0xe8, LOAD to OTR
        LS7366_1_CS = 1;
        wait_us(1);
        LS7366_1_CS = 0;
    } else {
        LS7366_2_CS = 0;
        wait_us(1);
        LS7366_cmd(LOAD,OTR);//cmd = 0xe8, LOAD to OTR
        LS7366_2_CS = 1;
        wait_us(1);

        LS7366_2_CS = 0;
    }
    wait_us(1);
    LS7366_cmd(RD,CNTR);  //cmd = 0x60, READ from CNTR
    count.byte_enc[3] = spi.write(0x00);
    count.byte_enc[2] = spi.write(0x00);
    count.byte_enc[1] = spi.write(0x00);
    count.byte_enc[0] = spi.write(0x00);

    if(chan_num!=2) {
        LS7366_1_CS = 1;
    } else {
        LS7366_2_CS = 1;
    }

    return count.long_enc;  //return count
}

void LS7366_quad_mode_x4(int chan_num)
{
    if(chan_num!=2) {
        LS7366_1_CS = 0;
    } else {
        LS7366_2_CS = 0;
    }
    wait_us(1);
    LS7366_cmd(WR,MDR0);// Write to the MDR0 register
    spi.write(0x03); // X4 quadrature count mode
    if(chan_num!=2) {
        LS7366_1_CS = 1;
    } else {
        LS7366_2_CS = 1;
    }
}

void LS7366_reset_counter(int chan_num)
{
    if(chan_num!=2) {
        LS7366_1_CS = 0;
    } else {
        LS7366_2_CS = 0;
    }
    wait_us(1);
    LS7366_cmd(CLR,DTR);//
    if(chan_num!=2) {
        LS7366_1_CS = 1;
    } else {
        LS7366_2_CS = 1;
    }
    wait_us(1);

    if(chan_num!=2) {
        LS7366_1_CS = 0;
    } else {
        LS7366_2_CS = 0;
    }
    wait_us(1);
    LS7366_cmd(LOAD,CNTR);//
    if(chan_num!=2) {
        LS7366_1_CS = 1;
    } else {
        LS7366_2_CS = 1;
    }
}

void LS7366_write_DTR(int chan_num,long enc_value)
{
    union bytes {
        char byte_enc[4];
        long long_enc;
    } count;

    count.long_enc = enc_value;

    if(chan_num!=2) {
        LS7366_1_CS = 0;
    } else {
        LS7366_2_CS = 0;
    }
    wait_us(1);
    LS7366_cmd(WR,DTR);//
    spi.write(count.byte_enc[3]);
    spi.write(count.byte_enc[2]);
    spi.write(count.byte_enc[1]);
    spi.write(count.byte_enc[0]);
    if(chan_num!=2) {
        LS7366_1_CS = 1;
    } else {
        LS7366_2_CS = 1;
    }

    if(chan_num!=2) {
        LS7366_1_CS = 0;
    } else {
        LS7366_2_CS = 0;
    }
    wait_us(1);
    LS7366_cmd(LOAD,CNTR);//
    if(chan_num!=2) {
        LS7366_1_CS = 1;
    } else {
        LS7366_2_CS = 1;
    }
}
float angleOld,angleNew,speed,speedD,Ts,dt,K;
float err,errP,dcP;
long enc;
Timer t;
DigitalOut mot1_ph2(p22);
PwmOut mot_en1(p23);
int cntr;
float dc;
int main ()
{
    mot_en1.period_us(50); 
    LS7366_1_CS = 1;        
    LS7366_reset_counter(1);
    LS7366_quad_mode_x4(1);
    LS7366_write_DTR(1,0);
    speed = 0.0;
    angleOld = 0.0;
    errP = 0.0;
    dcP = 0.0;
    Ts = 0.004; // 250 Hz
    K = 0.000212;
    
    cntr =0;
    while(cntr*Ts <= 1.0) {        
        t.start(); // start measuring comp time
        // encoder read and speed comp
        enc = LS7366_read_counter(1);
        angleNew = 360*enc/1250.0;        
        // Use minus sign so that dc>0 produces speed >0
        speed = -(angleNew-angleOld)/Ts; 
        // drive motor
        if (cntr*Ts <= 0.2) {
            speedD = 0.0;
        } else if (cntr*Ts <= 0.6) {
            speedD = 2000.0;
        } else {
            speedD = 3000.0; //4000.0 caused dc to saturate
        }
        
        // Ctrlr
        err = speedD-speed;
        //P: design for CL pole = 2* OL pole
        //dc = K*err; 
        //PI: design using canx with CL pole = 2* OL pole
        dc = dcP + 0.0005305*err-0.0003094*errP; 
        
        // limit dc to [-1,1]
        if (dc > 1.0) {
            dc = 1.0;
        } else if (dc < -1.0) {
            dc = -1.0;
        }
        // use sgn of dc to determine motor direction
        if (dc >0.0){
                mot1_ph2 = 0;                
                mot_en1 = dc;
            }
            else{
                mot1_ph2 = 1;
                mot_en1 = abs(dc);
            }  // -1.0< dc < 1.0
        // age variables    
        angleOld = angleNew; // age encoder measurement    
        dcP = dc;
        errP = err;
        t.stop(); // end measuring comp time        
        //printf("%f\n\r",t.read());  
        dt = Ts-t.read();
        //printf("%f\n\r",dt);      
        printf("%5.4f %5.2f %5.2f %5.2f \n\r",cntr*Ts,speedD,speed,dc);
        //printf("%5.2f \n\r",angleNew);
        wait(dt); // wait to ensure sampling period set by Ts
        t.reset();
        cntr=cntr+1;
    }//while
    // stop motor when experiment is complete
    mot1_ph2 = 0;                
    mot_en1 = 0.0;
}//main