#include "mbed.h"
#include "TouchSense.h"

/*
// 1\
//  |\
//  | \
//  |  \
//  +---\---------> t
//       1
float brightness(float t) {
if (t < 0)
return 0;
if (t > 1)
return 0;
return 1-t;
}
*/

/*
//   1| /\
//    |/  \
//  .5|    \
//    |     \
//    +--|---\---------> t
//      1/3   1
float brightness(float t) {
if (t < 0)
return 0;
if (0 <= t && t < 1/3.0)
return .5+t*1.5;
if (1/3.0 <= t && t < 1)
return 1.5-t*1.5;
if (1 <= t)
return 0;
}
*/

// 1|   /\
//  |  /  \
//  | /    \
//  |/      \
//  +---|----\---------> t
//     1/2   1
float brightness(float t)
{
    if (t < 0)
        return 0;
    if (0 <= t && t < 0.5)
        return t*2;
    if (0.5 <= t && t < 1)
        return 2-t*2;
    if (1 <= t)
        return 0;
}

int main()
{
    PwmOut led1(p21), led2(p22), led3(p23);
    Timer timer;

    DigitalOut out(p19);
    AnalogIn in(p20);

    TouchSense sensor1(out, in);
    //sensor1.calibrate();

    for (;;) {
        if (! sensor1.touched()) {
            Thread::wait(1);
            continue;
        }

        timer.reset();
        timer.start();
        for (;;) {
            float t = timer.read();
            if (t > 1.2)
                break;
            led1 = brightness(t);
            led2 = brightness(t-0.1);
            led3 = brightness(t-0.2);
            Thread::wait(1);
        }
    }
}

// Local Variables: **
// c-basic-offset:4 **
// End: **
