#include "mbed.h"                   //Se declara la librería mbed.

Serial pc(USBTX, USBRX, 9600);      // tx, rx Conunicación Serial con la PC
Serial device(p9, p10, 9600);       // tx, rx Comunicación Serial con el Módulo STX3
DigitalOut RTS(p7, 1);              // Pin Digital de Salida "RTS"; Predefinido para valer 1 en su estado inactivo dentro del código.
DigitalIn CTS(p8, PullUp);          // Pin Digital de entrada "CTS" en modo Pull-Up, para encontrarse normalmente a VCC cuando no haya un pulso. 
int flag=1;                         // Declaración de la Bandera.

int main() {
    wait(5);                                                    // Se da un tiempo para que el analizador se estabilice
    pc.printf("El valor de CTS 1 es %d\n\r",CTS.read());        // Se lee el valor de la variable CTS, la cual debe ser 1
    pc.printf("El valor de RTS 1 es %d\n\r",RTS.read());        // Se lee el valor de la variable RTS, la cual debe ser 1
    RTS=0;           
                                               // Se manda un pulso en bajo en RTS, para inicial el proceso de transmisión
    while(flag==1){             // Flag inicialmente vale 1, así que el ciclo while cambiará hasta que esa condición no se cumpla           
        flag=CTS.read();        // Cuando entra el ciclo, se iguala flag a CTS, el cual cuando cambie a 0 provocará que termine el while (máx 125 ms)
        pc.printf("El valor de flag es %d\n\r", flag);    // Se imprime el valor de flag, para identificar cuando termina el ciclo while
        }
        
        // En este momento inicia una "ventana" o lapso durante la cual se podrán realizar transmisiones.  
        
        wait(.1);               // Se esperan .1 segundos, para realizar la transmisiones.
        device.putc(0XAA);      // Se envía un mensaje en Hexadecimal, dado por GlobalStar
        device.putc(0X05);
        device.putc(0X04);
        device.putc(0XFD);
        device.putc(0X82);
        wait(.1);               // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
        //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
        RTS=1;                  // Se cambia el estado de RTS a alto, con esto se termina "la ventana" o lapso de transmisiones
        
        //Al cambiar el estado de RTS, CTS también cambiará a alto.
        
        while(1) {                      // Ciclo infinito
        if(device.readable()) {         // Se esperan datos provenientes del TX del módulo STX3
            pc.putc(device.getc());     // Se muestra en pantalla la respuesta recibida por el módulo STX3 como una reacción al mensaje en HEX enviado
            }
    }
}