#include "mbed.h"                   //Se declara la librería mbed.
#include "rtos.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX, 9600);      // tx, rx Conunicación Serial con la PC
Serial device(p9, p10, 9600);       // tx, rx Comunicación Serial con el Módulo STX3
DigitalOut RTS(p7, 1);              // Pin Digital de Salida "RTS"; Predefinido para valer 1 en su estado inactivo dentro del código.
DigitalIn CTS(p8, PullUp);          // Pin Digital de entrada "CTS" en modo Pull-Up, para encontrarse normalmente a VCC cuando no haya un pulso. 
int flag=1;                         // Declaración de la Bandera.
Thread thread;

void respuesta(){
    while(1){
    if(device.readable()) {         // Se esperan datos provenientes del TX del módulo STX3
            pc.putc(device.getc());     // Se muestra en pantalla la respuesta recibida por el módulo STX3 como una reacción al mensaje en HEX enviado
            }
            }
    }

void stx3()
    {
    Thread::wait(5000);                                                    // Se da un tiempo para que el analizador se estabilice
    pc.printf("El valor de CTS 1 es %d\n\r",CTS.read());        // Se lee el valor de la variable CTS, la cual debe ser 1
    pc.printf("El valor de RTS 1 es %d\n\r",RTS.read());        // Se lee el valor de la variable RTS, la cual debe ser 1
    RTS=0;                                                      // Se manda un pulso en bajo en RTS, para inicial el proceso de transmisión
    while(flag==1){             // Flag inicialmente vale 1, así que el ciclo while cambiará hasta que esa condición no se cumpla           
        flag=CTS.read();        // Cuando entra el ciclo, se iguala flag a CTS, el cual cuando cambie a 0 provocará que termine el while (máx 125 ms)
        pc.printf("El valor de flag es %d\n\r", flag);    // Se imprime el valor de flag, para identificar cuando termina el ciclo while
        }
    }
        
int main() { 
    thread.start(respuesta);
       
        while(1) {
        
        switch (pc.getc())
        {
        case '1':
            {
            led1=!led1;
            stx3();
            Thread::wait(100);               // Query ESN
            device.putc(0XAA);      
            device.putc(0X05);
            device.putc(0X01);
            device.putc(0X50);
            device.putc(0XD5);
            Thread::wait(100);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            flag=1;         
            }
            break;  
            
        case '2':
            {
            led2=!led2;
            stx3();
            Thread::wait(100);                // Query Bursts Remaining
            device.putc(0XAA);      
            device.putc(0X05);
            device.putc(0X04);
            device.putc(0XFD);
            device.putc(0X82);
            Thread::wait(100);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            flag=1;               
            }
            break;
            
        case '3':
            {
            led3=!led3;
            stx3();
            Thread::wait(100);                // Query Firmware Version
            device.putc(0XAA);      
            device.putc(0X05);
            device.putc(0X05);
            device.putc(0X74);
            device.putc(0X93);
            Thread::wait(100);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            flag=1;               
            }
            break;
            }
        }
    }
                           
