#include "mbed.h"

RawSerial  pc(USBTX, USBRX); // Comunicacion serial via USB KL46Z a la PC
RawSerial  dev(PTE16,PTE17); // Comunicacion serial desde KL46Z a ESP8266
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalIn sw1(PTC3);  // Interrupcion para cambiar
DigitalIn sw2(PTC12); // Interrupcion para cambiar
 
void dev_recv()      // Funcion de SerialPasstrough
{
    led1 = !led1;
    while(dev.readable()) {
        pc.putc(dev.getc());
    }
}

void pc_recv()       // Funcion de SerialPasstrough
{
    led2 = !led2 ;
    while(pc.readable()) {
        dev.putc(pc.getc());
    }
}

int main()
{
    pc.baud(115200);  // Sincronismo de transmicion hacia la PC
    dev.baud(115200); // Sincronismo de transmicion hacia el dispositivo

    pc.attach(&pc_recv, Serial::RxIrq);
    dev.attach(&dev_recv, Serial::RxIrq);
    
    dev.puts("AT+RESTORE\r\n");  // Restablese la salida en puerto del dispositivo ESP8266
    wait(10);  // Tiempo de espera de 1 seg. para esperar respuesta del ESP8266
    
    dev.puts("AT+CWMODE=1\r\n");  // configuracion en modo estacion al dispositivo ESP8266 por comandos AT
    wait(1);  // Tiempo de espera de 1 seg. para esperar respuesta del ESP8266
    
    dev.puts("AT+CWJAP=\"LEIS-1\",\"leis@3459\"\r\n"); // Se enlaza a la red de nombre "SE18" y su password "12345678" a traves de comandos AT
    wait(10);
    
   // dev.puts("AT+CIPSTA=\"192.168.4.3\",\"192.168.4.1\",\"255.255.255.0\"\r\n"); // Se coloca IP fijo, con el IP del Servidor y mascara /24
   // wait(1);
    
    dev.puts("AT+CIPMUX=1\r\n"); // Se declara que el Modulo ESP8266 trabaje con conexciones multiples
    wait(1);
    
    dev.puts("AT+CIPSTA?\r\n");
    wait(1);
            
    while(1) {
    if (sw1==0){
        dev.puts("AT+CIPCLOSE=1\r\n");
        wait(1);
        dev.puts("AT+CIPSTART=1,\"UDP\",\"10.1.1.130\",1001,1003,0\r\n"); // coneccion con Curu
        wait(1);
        dev.puts("AT+CIPCLOSE=2\r\n");
        wait(1);
        dev.puts("AT+CIPSTART=2,\"UDP\",\"192.168.4.2\",1002,1003,0\r\n"); // coneccion con BJ
        wait(1);
        }
    if (sw2==0){
        dev.puts("AT+CIPSEND=1,8\r\n");
        wait(1);
        dev.puts("FUNCIONA");
        wait(1);
        }
    }
}
