#include "mbed.h"



RawSerial  pc(USBTX, USBRX);
RawSerial  wifi(PTE0, PTE1);
DigitalOut led1(LED_GREEN);
DigitalOut led4(LED_RED);
DigitalIn sw1(SW1); 
DigitalIn sw2(SW3); 

void wifi_recv()
{
    led1 = !led1;
    
    while(wifi.readable()) {
       
        pc.putc(wifi.getc());
    }
}

void pc_recv()
{
    led4 = !led4;
     
    while(pc.readable()) {
        wifi.putc(pc.getc());
    }
}

int main()
{
    pc.baud(115200);
    wifi.baud(115200);

    pc.attach(&pc_recv, Serial::RxIrq);
    wifi.attach(&wifi_recv, Serial::RxIrq);
    
    //CFG
    wifi.puts("AT+CWMODE=2\r\n"); //modo AP
    wait(0.1);
    wifi.puts("AT+CWSAP=\"SE18\",\"12345678\",1,2\r\n"); //configura el ssid, pass, canal y encriptacion
    wait(0.1);
    wifi.puts("AT+CWSAP?\r\n"); // verifica que se seteo correctamente
    wait(0.1);
    wifi.puts("AT+CWDHCP=0,0\r\n"); //deshabilita DHCP en modo softAP
    wait(0.1);
    wifi.puts("AT+CIPMUX=1\r\n"); //permite hasta 4 conexiones simultaneas
    wait(0.1);
    //wifi.puts("AT+CIPSERVER=1,80\r\n"); //iniciar server en el puerto 80
    //wait(0.1);

    wifi.puts("AT+CIPAP=\"192.168.4.1\"\r\n"); // configura ip
    wait(0.1);
    
    

    while(1) {
        
        //SW2 inicia y/o reinicia las conexiones
        //SW1 envia datos a todas las estaciones configuradas
        
        if(sw2 == 0){
            wifi.puts("AT+CIPCLOSE=0\r\n"); 
            wait(0.2);
            wifi.puts("AT+CIPSTART=0,\"UDP\",\"192.168.4.2\",1002,1001,0\r\n"); //inicia conexion con javier
            wait(0.2); 
            
            wifi.puts("AT+CIPCLOSE=1\r\n"); 
            wait(0.2);
            wifi.puts("AT+CIPSTART=1,\"UDP\",\"192.168.4.3\",1003,1001,0\r\n"); //inicia conexion con juancarlos
            wait(0.2); 
            
            wifi.puts("AT+CIPCLOSE=2\r\n"); 
            wait(0.2);
            wifi.puts("AT+CIPSTART=2,\"UDP\",\"192.168.4.4\",1004,1001,0\r\n"); //inicia conexion con benja
            wait(0.2); 
            
            }
            
        if(sw1 == 0){
            
            wifi.puts("AT+CIPSEND=0,18\r\n"); //envia datos a javier
            wait(0.2);
            wifi.puts("HOLA SOY CHRISTIAN"); 
            wait(0.2);
            
            
            wifi.puts("AT+CIPSEND=1,18\r\n"); //envia datos a juanca
            wait(0.2);
            wifi.puts("HOLA SOY CHRISTIAN");
            wait(0.2);
            
            
            wifi.puts("AT+CIPSEND=2,18\r\n"); //envia datos a benja
            wait(0.2);
            wifi.puts("HOLA SOY CHRISTIAN");
            wait(0.2);
            
            
            }
        
        sleep();
    }
}

/* Para pedir un get a un servidor.
    
    wifi.puts("AT+CWMODE=1\r\n"); //modo ESTACION
    wait(0.1);
    wifi.puts("AT+CWJAP=\"TP-LINK_3F30\",\"90055904\"\r\n"); //conectarse a un AP
    wait(10);
    wifi.puts("AT+CIPSTART=0,\"TCP\",\"192.168.0.101\",80\r\n"); //Iniciar conexion
    wait(0.2);
    wifi.puts("AT+CIPSEND=0,39\r\n"); //Mandar datos 39 es la cant de caracteres
    wait(0.2);
    wifi.puts("GET / HTTP/1.1\r\nHost: 192.168.0.101\r\n\r\n"); //Mandar datos 39 es la cant de caracteres
    wait(0.3);
    
      SI RECIBE UNA PETICION DESDE UN BROWSER
    SE PUEDE RESPONDER CON EL COMANDO : AT+CIPSEND=<id de conexion>,<longitud caracteres>
    
    > 
    <HTML>
    <HEAD>
        <meta charset="utf-8">
        <TITLE>Mi pagina de prueba</TITLE>
    </HEAD>
    <BODY>
        <H1>SISTEMAS EMBEBIDOS 2018 </H1>
    </body>
    </html> 
    
    
    */

