/**********************************************************
* UKESF Headstart Summer School - Robot Programming Lab   *
**********************************************************/

// Note: A line beginning with // is a 'comment' and is
// ignored by the compiler [it is shown in green text in the IDE]

// Include main.h - this contains the code needed to setup
// the Psi-Swarm robot and its hardware
#include "main.h"

// You can change the author name to saomething else if you want - just make sure it is no more than 16 characters long
char * author_name  = "YRL";

/// The main routine: it is recommended to leave this function alone and add user code to the above functions
int main()
{
    // init() in psiswarm.cpp sets up the robot - we need to run this line of code before anything else or the robot won't work.
    init();

    // We shall create a for-loop to try to move the robot in a 50cm square.
    for(int i=0; i<4; i++){
      
      // Move the robot forward 50cm
      move_forward(50);
      
      // Wait one second
      wait(1.0);
      
      // Turn the robot right 90 degrees
      turn_right();
      
      // Wait for one second
      wait(1.0);
    }
    
    // When we have finished our code, we want to leave the MBED in an endless loop.
    while(1){}
}

/**
* void move_forward(int distance)
* This function should move the robot forward for the distance
* (in centimeter) specified by distance
*/
void move_forward(int distance)
{
    float left_motor_speed = 0.4;
    float right_motor_speed = 0.4;
    float cm_per_second = 25.0;
    float delay = distance / cm_per_second;
    set_motor_speed(left_motor_speed, right_motor_speed);
    wait(delay);
    brake();
}

/**
* void turn_right()
* This function should turn the robot right by 90 degrees.
*/
void turn_right()
{
    float speed = 0.2;
    float degrees_per_second = 150.0;
    float delay = 90 / degrees_per_second;
    turn(speed);
    wait(delay);
    brake();
}

/**
* void turn_left()
* This function should turn the robot left by 90 degrees.  You will need to fill in the code here 
* HINT: You can use Ctrl-C and Ctrl-V to copy\paste blocks of code!
*/
void turn_left()
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////

// You can ignore the code beyond this point: we need these variables and functions to make the code
// compile without errors, but we aren't using the functions for this lab session.
char * program_name = "Headstart";
char * version_name = "0.5";
void handle_switch_event(char switch_state){}
void handle_user_serial_message(char * message, char length, char interface){}