/**********************************************************
* UKESF Headstart Summer School - Robot Programming Lab   *
**********************************************************/

#ifndef MAIN_H
#define MAIN_H

#include "psiswarm.h"

int main(void);
void handle_switch_event(char switch_state); 
void handle_user_serial_message(char * message, char length, char interface);

static float left_speeds[2] = {0.0, 0.0};
static float right_speeds[2] = {0.0, 0.0};
static float forward_speeds[2] = {0.0, 0.0};

void inline set_left_turn_speeds(float l, float r) { left_speeds[0] = l; left_speeds[1] = r; }
void inline set_right_turn_speeds(float l, float r) { right_speeds[0] = l; right_speeds[1] = r; }
void inline set_forward_wheel_speeds(float l, float r) { forward_speeds[0] = l; forward_speeds[1] = r; }

static float cm_in_5_seconds = 40;
static float degrees_in_5_seconds = 300;

void inline cms_travelled_in_5_seconds(float dist) { cm_in_5_seconds = dist; }
void inline degrees_turned_in_5_seconds(float degrees) { degrees_in_5_seconds = degrees; }

inline void forward_timed(float seconds)
{
    set_motor_speed(forward_speeds[0], forward_speeds[1]);
    wait(seconds);
    brake();
}
    
inline void forward_cm(float distance_in_cm)
{
    float cm_in_1_second = cm_in_5_seconds/5;
    float seconds_for_1_cm = 1/cm_in_1_second;
    float seconds_to_move = seconds_for_1_cm * distance_in_cm;
    
    forward_timed(seconds_to_move);
}


inline void turn_right_timed(float turn_time)
{
    set_motor_speed(right_speeds[0], right_speeds[1]);
    wait(turn_time);
    brake();
}
    
inline void turn_right_degrees(float degrees)
{
    float degrees_in_1_second = degrees_in_5_seconds/5;
    float seconds_per_degree = 1/degrees_in_1_second;
    float turn_time = seconds_per_degree * degrees;
    
    turn_right_timed(turn_time);
}

inline void turn_left_timed(float turn_time)
{
    set_motor_speed(left_speeds[0], left_speeds[1]);
    wait(turn_time);
    brake();
}
    
inline void turn_left_degrees(float degrees)
{
    float degrees_in_1_second = degrees_in_5_seconds/5;
    float seconds_per_degree = 1/degrees_in_1_second;
    float turn_time = seconds_per_degree * degrees;
    
    turn_left_timed(turn_time);
}

#endif