/* University of York Robotics Laboratory PsiSwarm Library: Display Driver Header File
 * 
 * File: display.h
 *
 * (C) Dept. Electronics & Computer Science, University of York
 * James Hilder, Alan Millard, Alexander Horsfield, Homero Elizondo, Jon Timmis
 *
 * PsiSwarm Library Version: 0.41
 *
 * March 2016
 *
 *
 * Driver for the Midas 16x2 I2C LCD Display (MCCOG21605x6W) LCD
 *
 * Farnell part 2218942 or 2063206
 *
 */ 
 
 
#ifndef DISPLAY_H
#define DISPLAY_H

#define PAGE_TIME 0.4
#define CLEAR_TIME 0.8

class Display : public Stream {

// Public Functions

public:

   /** Create the LCD Display object connected to the default pins
     *
     * @param sda pin   - default is p28
     * @param scl pin   - default is p27
     * @param reset pin - default is p29
     * @param backlight pin - default is p30
     */
     
    Display();
    
    /** Create the LCD Display object connected to specific pins
     *
     */
    Display(PinName sda, PinName scl, PinName reset, PinName backlight);

//Print string message
void write_string(char * message);

//Print string message of given length
void write_string(char * message, char length);

//Set the row and column of cursor position
void set_position(char row, char column);

// Enable or disable cursor
void set_cursor(char enable);

// Enable or disable cursor blink
void set_blink(char enable);

// Enable or disable display
void set_display(char enable);

// Set the brightness of the backlight
void set_backlight_brightness(float brightness);

// Special function for when debug messages are sent to display
void debug_page(char * message, char length);

void IF_restore_page(void);

void IF_debug_multipage(void);

void IF_backlight_toggle(void);

//Parts of initialisation routine
void post_init(void);
void post_post_init(void);


// Clear display
void clear_display();

//Set cursor to home position
void home();

// Send a 1-byte control message to the display
int i2c_message(char byte);

// Default initialisation sequence for the display
void init_display(char mode);

int disp_putc(int c);


private :

    I2C _i2c;
    DigitalOut _reset;
    DigitalOut _backlight;
    
    char display_on;
    char cursor_on;
    char blink_on;
    
    void _set_display();
    
    virtual int _putc(int c);
    virtual int _getc();
    
};

#endif // DISPLAY_H