/* University of York Robotics Laboratory PsiSwarm Library: Psi-BASIC Interpretter Code
 * 
 * File: basic.cpp
 *
 * (C) Dept. Electronics & Computer Science, University of York
 * James Hilder, Alexander Horsfield, Alan Millard, Homero Elizondo, Jon Timmis
 *
 * PsiSwarm Library Version: 0.41
 *
 * March 2016
 *
 */
 
 #include "psiswarm.h"
 
 LocalFileSystem local("local");
 
 void read_list_of_file_names()
 {
    DIR *dp;
    struct dirent *dirp;
    dp = opendir("/local");
    if(dp == NULL) pc.printf("- File handling error: Failed to open directory\n");
    debug("- Reading FLASH storage for PsiBasic files\n");
    //read all files in MBED root directory and add matching file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        string filename = (string) dirp->d_name;
         if (filename.compare(filename.size()-4,4,".PSI") == 0)
            {
                psi_basic_file_count ++ ;
                debug("- Found file: %s\n",filename.c_str());
                basic_filenames.push_back(filename);
            }
    }
    closedir(dp);
 }
 
//....example call in your "main" code somewhere.....
 
 // read file names into vector of strings
 
