/* University of York Robotics Laboratory PsiSwarm Library: Sensor Functions Header File
 * 
 * File: sensors.h
 *
 * (C) Dept. Electronics & Computer Science, University of York
 * James Hilder, Alan Millard, Alexander Horsfield, Homero Elizondo, Jon Timmis
 *
 * PsiSwarm Library Version: 0.41
 *
 * March 2016
 *
 */
 
#ifndef SENSORS_H
#define SENSORS_H

float get_battery_voltage ( void );
float get_current ( void );
float get_dc_voltage ( void );

float get_temperature ( void );
void enable_ultrasonic_ticker( void );
void disable_ultrasonic_ticker( void );
void update_ultrasonic_measure ( void );
void IF_read_ultrasonic_measure ( void );
float read_reflected_ir_distance ( char index );
float get_reflected_ir_distance ( char index );
unsigned short get_background_raw_ir_value ( char index );
unsigned short get_illuminated_raw_ir_value ( char index );
void store_reflected_ir_distances ( void );
void store_background_raw_ir_values ( void );
void store_illuminated_raw_ir_values ( void );
float calculate_reflected_distance ( unsigned short background_value, unsigned short illuminated_value );
unsigned short read_illuminated_raw_ir_value ( char index ) ;
 
unsigned short get_background_base_ir_value ( char index );
unsigned short get_illuminated_base_ir_value ( char index );
unsigned short calculate_base_ir_value ( char index );
unsigned short calculate_side_ir_value ( char index );

int get_bearing_from_ir_array ( unsigned short * ir_sensor_readings);
void store_ir_values ( void );
void store_base_ir_values ( void );
void store_background_base_ir_values ( void );
void store_illuminated_base_ir_values ( void );

void store_line_position ( void );
void calibrate_base_ir_sensors ( void );

#endif