/* University of York Robotics Laboratory PsiSwarm Library: Motor Functions Header File
 * 
 * File: motors.h
 *
 * (C) Dept. Electronics & Computer Science, University of York
 * James Hilder, Alan Millard, Alexander Horsfield, Homero Elizondo, Jon Timmis
 *
 * PsiSwarm Library Version: 0.5
 *
 * April 2016
 *
 *
 */ 

#ifndef MOTORS_H
#define MOTORS_H

void set_motor_speed(float left_motor_speed, float right_motor_speed);
void set_left_motor_speed(float speed);
void set_right_motor_speed(float speed);
void brake_left_motor(void);
void brake_right_motor(void);
void brake(void);
void stop(void);
void forward(float speed);
void backward(float speed);
void turn(float speed);

// New time based functions (library v0.3)
void time_based_forward(float speed, int microseconds, char brake);
void time_based_turn(float speed, int microseconds, char brake);
int time_based_turn_degrees(float speed, float degrees, char brake);
float get_maximum_turn_angle(int microseconds);
int get_time_based_turn_time(float speed, float degrees);
void IF_check_time_for_existing_time_based_action();
void IF_end_time_based_action();

void IF_update_motors();
float IF_calibrated_left_speed(float speed);
float IF_calibrated_right_speed(float speed);
float IF_calibrated_speed(float speed);
void IF_init_motors(void);

#endif